/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.StringHelper;
import org.slf4j.LoggerFactory;

public class DeadLetterChannelBuilder
extends DefaultErrorHandlerBuilder {
    public DeadLetterChannelBuilder() {
    }

    public DeadLetterChannelBuilder(Endpoint deadLetter) {
        this.setDeadLetter(deadLetter);
        this.getRedeliveryPolicy().setLogExhausted(false);
    }

    public DeadLetterChannelBuilder(String uri) {
        this.setDeadLetterUri(uri);
    }

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        this.validateDeadLetterUri(routeContext);
        DeadLetterChannel answer = new DeadLetterChannel(routeContext.getCamelContext(), processor, this.getLogger(), this.getOnRedelivery(), this.getRedeliveryPolicy(), this.getExceptionPolicyStrategy(), this.getFailureProcessor(), this.getDeadLetterUri(), this.isDeadLetterHandleNewException(), this.isUseOriginalMessage(), this.isUseOriginalBody(), this.getRetryWhilePolicy(routeContext.getCamelContext()), this.getExecutorService(routeContext.getCamelContext()), this.getOnPrepareFailure(), this.getOnExceptionOccurred());
        this.configure(routeContext, (ErrorHandler)answer);
        return answer;
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        DeadLetterChannelBuilder answer = new DeadLetterChannelBuilder();
        super.cloneBuilder(answer);
        return answer;
    }

    @Override
    public Processor getFailureProcessor() {
        if (this.failureProcessor == null) {
            SendProcessor child = new SendProcessor(this.deadLetter, ExchangePattern.InOnly);
            this.failureProcessor = new FatalFallbackErrorHandler((Processor)child, true);
        }
        return this.failureProcessor;
    }

    protected void validateDeadLetterUri(RouteContext routeContext) {
        if (this.deadLetter == null) {
            StringHelper.notEmpty((String)this.deadLetterUri, (String)"deadLetterUri", (Object)this);
            this.deadLetter = routeContext.getCamelContext().getEndpoint(this.deadLetterUri);
            if (this.deadLetter == null) {
                throw new NoSuchEndpointException(this.deadLetterUri);
            }
        }
    }

    @Override
    protected CamelLogger createLogger() {
        return new CamelLogger(LoggerFactory.getLogger(DeadLetterChannel.class), LoggingLevel.ERROR);
    }

    @Override
    public String toString() {
        return "DeadLetterChannelBuilder(" + this.deadLetterUri + ")";
    }
}

