/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.util.FileUtil;

@org.apache.camel.spi.annotations.Component(value="platform-http")
public class PlatformHttpComponent
extends DefaultComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    @Metadata(label="advanced", description="An HTTP Server engine implementation to serve the requests")
    private PlatformHttpEngine engine;

    public PlatformHttpComponent() {
    }

    public PlatformHttpComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PlatformHttpEndpoint endpoint = new PlatformHttpEndpoint(uri, remaining, (Component)this);
        endpoint.setPlatformHttpEngine(this.engine);
        return endpoint;
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public PlatformHttpEngine getEngine() {
        return this.engine;
    }

    public PlatformHttpComponent setEngine(PlatformHttpEngine engine) {
        this.engine = engine;
        return this;
    }

    private Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = camelContext.getRestConfiguration("platform-http", true);
        }
        Map map = RestComponentHelper.initRestEndpointProperties((String)"platform-http", (RestConfiguration)config);
        boolean cors = config.isEnableCORS();
        if (cors) {
            map.put("optionsEnabled", "true");
        }
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        RestComponentHelper.addHttpRestrictParam((Map)map, (String)verb, (boolean)cors);
        String url = RestComponentHelper.createRestConsumerUrl((String)"platform-http", (String)path, (Map)map);
        PlatformHttpEndpoint endpoint = (PlatformHttpEndpoint)camelContext.getEndpoint(url, PlatformHttpEndpoint.class);
        this.setProperties(camelContext, (Object)endpoint, parameters);
        endpoint.setConsumes(consumes);
        endpoint.setProduces(produces);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }
}

