/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Notification;

public class JMXConsumerNotificationFilter
extends AttributeChangeNotificationFilter {
    private final String stringToCompare;
    private final boolean notifyMatch;

    public JMXConsumerNotificationFilter(String observedAttribute, String stringToCompare, boolean notifyMatch) {
        this.enableAttribute(observedAttribute);
        this.stringToCompare = stringToCompare;
        this.notifyMatch = notifyMatch;
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        boolean enabled = super.isNotificationEnabled(notification);
        if (!enabled) {
            return false;
        }
        boolean match = false;
        if (this.stringToCompare != null) {
            AttributeChangeNotification acn = (AttributeChangeNotification)notification;
            Object newValue = acn.getNewValue();
            if ("null".equals(this.stringToCompare) && newValue == null) {
                match = true;
            } else if (newValue != null) {
                match = this.stringToCompare.equals(newValue.toString());
            }
            return this.notifyMatch == match;
        }
        return true;
    }
}

