/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class PostgresConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,postgres";
    @UriParam(label="consumer,postgres")
    private String messageKeyColumns;
    @UriParam(label="consumer,postgres", defaultValue="dbz_publication")
    private String publicationName = "dbz_publication";
    @UriParam(label="consumer,postgres")
    private String columnBlacklist;
    @UriParam(label="consumer,postgres")
    private String schemaBlacklist;
    @UriParam(label="consumer,postgres")
    private String tableBlacklist;
    @UriParam(label="consumer,postgres", defaultValue="6")
    private int slotMaxRetries = 6;
    @UriParam(label="consumer,postgres", defaultValue="columns_diff")
    private String schemaRefreshMode = "columns_diff";
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean slotDropOnStop = false;
    @UriParam(label="consumer,postgres", defaultValue="disable")
    private String databaseSslmode = "disable";
    @UriParam(label="consumer,postgres")
    private String databaseSslcert;
    @UriParam(label="consumer,postgres", defaultValue="500")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,postgres")
    private String databaseInitialStatements;
    @UriParam(label="consumer,postgres", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,postgres")
    private String databaseSslfactory;
    @UriParam(label="consumer,postgres", defaultValue="10000")
    private int statusUpdateIntervalMs = 10000;
    @UriParam(label="consumer,postgres")
    private int snapshotFetchSize;
    @UriParam(label="consumer,postgres", defaultValue="10000")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,postgres")
    private String databaseDbname;
    @UriParam(label="consumer,postgres")
    private String databaseUser;
    @UriParam(label="consumer,postgres")
    private String databaseSslkey;
    @UriParam(label="consumer,postgres")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,postgres", defaultValue="0")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,postgres", defaultValue="v2")
    private String sourceStructVersion = "v2";
    @UriParam(label="consumer,postgres", defaultValue="decoderbufs")
    private String pluginName = "decoderbufs";
    @UriParam(label="consumer,postgres")
    private String databaseSslpassword;
    @UriParam(label="consumer,postgres", defaultValue="__debezium_unavailable_value")
    private String toastedValuePlaceholder = "__debezium_unavailable_value";
    @UriParam(label="consumer,postgres")
    private String schemaWhitelist;
    @UriParam(label="consumer,postgres")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,postgres")
    private String databaseSslrootcert;
    @UriParam(label="consumer,postgres", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,postgres", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,postgres", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,postgres")
    private String snapshotCustomClass;
    @UriParam(label="consumer,postgres", defaultValue="debezium")
    private String slotName = "debezium";
    @UriParam(label="consumer,postgres", defaultValue="json")
    private String hstoreHandlingMode = "json";
    @UriParam(label="consumer,postgres", defaultValue="0")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,postgres")
    private String tableWhitelist;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,postgres", defaultValue="10000")
    private long slotRetryDelayMs = 10000L;
    @UriParam(label="consumer,postgres", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,postgres", defaultValue="true")
    private boolean databaseTcpkeepalive = true;
    @UriParam(label="consumer,postgres")
    private String databaseHistoryFileFilename;
    @UriParam(label="consumer,postgres", defaultValue="0")
    private long xminFetchIntervalMs = 0L;
    @UriParam(label="consumer,postgres", defaultValue="adaptive")
    private String timePrecisionMode = "adaptive";
    @UriParam(label="consumer,postgres")
    @Metadata(required=true)
    private String databaseServerName;
    @UriParam(label="consumer,postgres", defaultValue="5432")
    private int databasePort = 5432;
    @UriParam(label="consumer,postgres", defaultValue="false")
    private boolean includeUnknownDatatypes = false;
    @UriParam(label="consumer,postgres")
    private String databaseHostname;
    @UriParam(label="consumer,postgres")
    private String slotStreamParams;

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setPublicationName(String publicationName) {
        this.publicationName = publicationName;
    }

    public String getPublicationName() {
        return this.publicationName;
    }

    public void setColumnBlacklist(String columnBlacklist) {
        this.columnBlacklist = columnBlacklist;
    }

    public String getColumnBlacklist() {
        return this.columnBlacklist;
    }

    public void setSchemaBlacklist(String schemaBlacklist) {
        this.schemaBlacklist = schemaBlacklist;
    }

    public String getSchemaBlacklist() {
        return this.schemaBlacklist;
    }

    public void setTableBlacklist(String tableBlacklist) {
        this.tableBlacklist = tableBlacklist;
    }

    public String getTableBlacklist() {
        return this.tableBlacklist;
    }

    public void setSlotMaxRetries(int slotMaxRetries) {
        this.slotMaxRetries = slotMaxRetries;
    }

    public int getSlotMaxRetries() {
        return this.slotMaxRetries;
    }

    public void setSchemaRefreshMode(String schemaRefreshMode) {
        this.schemaRefreshMode = schemaRefreshMode;
    }

    public String getSchemaRefreshMode() {
        return this.schemaRefreshMode;
    }

    public void setSlotDropOnStop(boolean slotDropOnStop) {
        this.slotDropOnStop = slotDropOnStop;
    }

    public boolean getSlotDropOnStop() {
        return this.slotDropOnStop;
    }

    public void setDatabaseSslmode(String databaseSslmode) {
        this.databaseSslmode = databaseSslmode;
    }

    public String getDatabaseSslmode() {
        return this.databaseSslmode;
    }

    public void setDatabaseSslcert(String databaseSslcert) {
        this.databaseSslcert = databaseSslcert;
    }

    public String getDatabaseSslcert() {
        return this.databaseSslcert;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setDatabaseInitialStatements(String databaseInitialStatements) {
        this.databaseInitialStatements = databaseInitialStatements;
    }

    public String getDatabaseInitialStatements() {
        return this.databaseInitialStatements;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setDatabaseSslfactory(String databaseSslfactory) {
        this.databaseSslfactory = databaseSslfactory;
    }

    public String getDatabaseSslfactory() {
        return this.databaseSslfactory;
    }

    public void setStatusUpdateIntervalMs(int statusUpdateIntervalMs) {
        this.statusUpdateIntervalMs = statusUpdateIntervalMs;
    }

    public int getStatusUpdateIntervalMs() {
        return this.statusUpdateIntervalMs;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseDbname() {
        return this.databaseDbname;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseSslkey(String databaseSslkey) {
        this.databaseSslkey = databaseSslkey;
    }

    public String getDatabaseSslkey() {
        return this.databaseSslkey;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getSourceStructVersion() {
        return this.sourceStructVersion;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setDatabaseSslpassword(String databaseSslpassword) {
        this.databaseSslpassword = databaseSslpassword;
    }

    public String getDatabaseSslpassword() {
        return this.databaseSslpassword;
    }

    public void setToastedValuePlaceholder(String toastedValuePlaceholder) {
        this.toastedValuePlaceholder = toastedValuePlaceholder;
    }

    public String getToastedValuePlaceholder() {
        return this.toastedValuePlaceholder;
    }

    public void setSchemaWhitelist(String schemaWhitelist) {
        this.schemaWhitelist = schemaWhitelist;
    }

    public String getSchemaWhitelist() {
        return this.schemaWhitelist;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabaseSslrootcert(String databaseSslrootcert) {
        this.databaseSslrootcert = databaseSslrootcert;
    }

    public String getDatabaseSslrootcert() {
        return this.databaseSslrootcert;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setSnapshotCustomClass(String snapshotCustomClass) {
        this.snapshotCustomClass = snapshotCustomClass;
    }

    public String getSnapshotCustomClass() {
        return this.snapshotCustomClass;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public void setHstoreHandlingMode(String hstoreHandlingMode) {
        this.hstoreHandlingMode = hstoreHandlingMode;
    }

    public String getHstoreHandlingMode() {
        return this.hstoreHandlingMode;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setTableWhitelist(String tableWhitelist) {
        this.tableWhitelist = tableWhitelist;
    }

    public String getTableWhitelist() {
        return this.tableWhitelist;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean getTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setSlotRetryDelayMs(long slotRetryDelayMs) {
        this.slotRetryDelayMs = slotRetryDelayMs;
    }

    public long getSlotRetryDelayMs() {
        return this.slotRetryDelayMs;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setDatabaseTcpkeepalive(boolean databaseTcpkeepalive) {
        this.databaseTcpkeepalive = databaseTcpkeepalive;
    }

    public boolean getDatabaseTcpkeepalive() {
        return this.databaseTcpkeepalive;
    }

    public void setDatabaseHistoryFileFilename(String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryFileFilename() {
        return this.databaseHistoryFileFilename;
    }

    public void setXminFetchIntervalMs(long xminFetchIntervalMs) {
        this.xminFetchIntervalMs = xminFetchIntervalMs;
    }

    public long getXminFetchIntervalMs() {
        return this.xminFetchIntervalMs;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setDatabaseServerName(String databaseServerName) {
        this.databaseServerName = databaseServerName;
    }

    public String getDatabaseServerName() {
        return this.databaseServerName;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setIncludeUnknownDatatypes(boolean includeUnknownDatatypes) {
        this.includeUnknownDatatypes = includeUnknownDatatypes;
    }

    public boolean getIncludeUnknownDatatypes() {
        return this.includeUnknownDatatypes;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    public void setSlotStreamParams(String slotStreamParams) {
        this.slotStreamParams = slotStreamParams;
    }

    public String getSlotStreamParams() {
        return this.slotStreamParams;
    }

    @Override
    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "message.key.columns", this.messageKeyColumns);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "publication.name", this.publicationName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.blacklist", this.columnBlacklist);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.blacklist", this.schemaBlacklist);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.blacklist", this.tableBlacklist);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.max.retries", Integer.valueOf(this.slotMaxRetries));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.refresh.mode", this.schemaRefreshMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.drop_on_stop", Boolean.valueOf(this.slotDropOnStop));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslmode", this.databaseSslmode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslcert", this.databaseSslcert);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "poll.interval.ms", Long.valueOf(this.pollIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.initial.statements", this.databaseInitialStatements);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.topics.prefix", this.heartbeatTopicsPrefix);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslfactory", this.databaseSslfactory);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "status.update.interval.ms", Integer.valueOf(this.statusUpdateIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.fetch.size", Integer.valueOf(this.snapshotFetchSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.lock.timeout.ms", Long.valueOf(this.snapshotLockTimeoutMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.dbname", this.databaseDbname);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.user", this.databaseUser);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslkey", this.databaseSslkey);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.select.statement.overrides", this.snapshotSelectStatementOverrides);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.interval.ms", Integer.valueOf(this.heartbeatIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "source.struct.version", this.sourceStructVersion);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "plugin.name", this.pluginName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslpassword", this.databaseSslpassword);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "toasted.value.placeholder", this.toastedValuePlaceholder);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.whitelist", this.schemaWhitelist);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.password", this.databasePassword);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.sslrootcert", this.databaseSslrootcert);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.batch.size", Integer.valueOf(this.maxBatchSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode", this.snapshotMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size", Integer.valueOf(this.maxQueueSize));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.custom.class", this.snapshotCustomClass);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.name", this.slotName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "hstore.handling.mode", this.hstoreHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.delay.ms", Long.valueOf(this.snapshotDelayMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.whitelist", this.tableWhitelist);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "tombstones.on.delete", Boolean.valueOf(this.tombstonesOnDelete));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.retry.delay.ms", Long.valueOf(this.slotRetryDelayMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "decimal.handling.mode", this.decimalHandlingMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.tcpKeepAlive", Boolean.valueOf(this.databaseTcpkeepalive));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.history.file.filename", this.databaseHistoryFileFilename);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "xmin.fetch.interval.ms", Long.valueOf(this.xminFetchIntervalMs));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "time.precision.mode", this.timePrecisionMode);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.server.name", this.databaseServerName);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.port", Integer.valueOf(this.databasePort));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "include.unknown.datatypes", Boolean.valueOf(this.includeUnknownDatatypes));
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.hostname", this.databaseHostname);
        PostgresConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "slot.stream.params", this.slotStreamParams);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return PostgresConnector.class;
    }

    @Override
    protected ConfigurationValidation validateConnectorConfiguration() {
        if (PostgresConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databasePassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'databasePassword' must be set.");
        }
        if (PostgresConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databaseServerName)) {
            return ConfigurationValidation.notValid((String)"Required field 'databaseServerName' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    @Override
    public String getConnectorDatabaseType() {
        return "postgres";
    }
}

