/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.component.milo.KeyStoreLoader;
import org.apache.camel.component.milo.server.MiloServerComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;

public class MiloServerComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object component, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return MiloServerComponentConfigurer.doConfigureIgnoreCase(camelContext, component, name, value);
        }
        return MiloServerComponentConfigurer.doConfigure(camelContext, component, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object component, String name, Object value) {
        switch (name) {
            case "namespaceUri": {
                ((MiloServerComponent)((Object)component)).setNamespaceUri((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "applicationName": {
                ((MiloServerComponent)((Object)component)).setApplicationName((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "applicationUri": {
                ((MiloServerComponent)((Object)component)).setApplicationUri((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "productUri": {
                ((MiloServerComponent)((Object)component)).setProductUri((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bindPort": {
                ((MiloServerComponent)((Object)component)).setBindPort((Integer)MiloServerComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "strictEndpointUrlsEnabled": {
                ((MiloServerComponent)((Object)component)).setStrictEndpointUrlsEnabled((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "serverName": {
                ((MiloServerComponent)((Object)component)).setServerName((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "hostname": {
                ((MiloServerComponent)((Object)component)).setHostname((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securityPolicies": {
                ((MiloServerComponent)((Object)component)).setSecurityPolicies((Set)MiloServerComponentConfigurer.property((CamelContext)camelContext, Set.class, (Object)value));
                return true;
            }
            case "securityPoliciesById": {
                ((MiloServerComponent)((Object)component)).setSecurityPoliciesById((Collection)MiloServerComponentConfigurer.property((CamelContext)camelContext, Collection.class, (Object)value));
                return true;
            }
            case "userAuthenticationCredentials": {
                ((MiloServerComponent)((Object)component)).setUserAuthenticationCredentials((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "enableAnonymousAuthentication": {
                ((MiloServerComponent)((Object)component)).setEnableAnonymousAuthentication((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usernameSecurityPolicyUri": {
                ((MiloServerComponent)((Object)component)).setUsernameSecurityPolicyUri((SecurityPolicy)MiloServerComponentConfigurer.property((CamelContext)camelContext, SecurityPolicy.class, (Object)value));
                return true;
            }
            case "bindAddresses": {
                ((MiloServerComponent)((Object)component)).setBindAddresses((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "buildInfo": {
                ((MiloServerComponent)((Object)component)).setBuildInfo((BuildInfo)MiloServerComponentConfigurer.property((CamelContext)camelContext, BuildInfo.class, (Object)value));
                return true;
            }
            case "serverCertificate": {
                ((MiloServerComponent)((Object)component)).setServerCertificate((KeyStoreLoader.Result)MiloServerComponentConfigurer.property((CamelContext)camelContext, KeyStoreLoader.Result.class, (Object)value));
                return true;
            }
            case "certificateManager": {
                ((MiloServerComponent)((Object)component)).setCertificateManager((CertificateManager)MiloServerComponentConfigurer.property((CamelContext)camelContext, CertificateManager.class, (Object)value));
                return true;
            }
            case "certificateValidator": {
                ((MiloServerComponent)((Object)component)).setCertificateValidator((Supplier)MiloServerComponentConfigurer.property((CamelContext)camelContext, Supplier.class, (Object)value));
                return true;
            }
            case "defaultCertificateValidator": {
                ((MiloServerComponent)((Object)component)).setDefaultCertificateValidator((File)MiloServerComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((MiloServerComponent)((Object)component)).setBasicPropertyBinding((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((MiloServerComponent)((Object)component)).setLazyStartProducer((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((MiloServerComponent)((Object)component)).setBridgeErrorHandler((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object component, String name, Object value) {
        switch (name.toLowerCase()) {
            case "namespaceuri": {
                ((MiloServerComponent)((Object)component)).setNamespaceUri((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "applicationname": {
                ((MiloServerComponent)((Object)component)).setApplicationName((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "applicationuri": {
                ((MiloServerComponent)((Object)component)).setApplicationUri((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "producturi": {
                ((MiloServerComponent)((Object)component)).setProductUri((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "bindport": {
                ((MiloServerComponent)((Object)component)).setBindPort((Integer)MiloServerComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "strictendpointurlsenabled": {
                ((MiloServerComponent)((Object)component)).setStrictEndpointUrlsEnabled((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "servername": {
                ((MiloServerComponent)((Object)component)).setServerName((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "hostname": {
                ((MiloServerComponent)((Object)component)).setHostname((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "securitypolicies": {
                ((MiloServerComponent)((Object)component)).setSecurityPolicies((Set)MiloServerComponentConfigurer.property((CamelContext)camelContext, Set.class, (Object)value));
                return true;
            }
            case "securitypoliciesbyid": {
                ((MiloServerComponent)((Object)component)).setSecurityPoliciesById((Collection)MiloServerComponentConfigurer.property((CamelContext)camelContext, Collection.class, (Object)value));
                return true;
            }
            case "userauthenticationcredentials": {
                ((MiloServerComponent)((Object)component)).setUserAuthenticationCredentials((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "enableanonymousauthentication": {
                ((MiloServerComponent)((Object)component)).setEnableAnonymousAuthentication((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "usernamesecuritypolicyuri": {
                ((MiloServerComponent)((Object)component)).setUsernameSecurityPolicyUri((SecurityPolicy)MiloServerComponentConfigurer.property((CamelContext)camelContext, SecurityPolicy.class, (Object)value));
                return true;
            }
            case "bindaddresses": {
                ((MiloServerComponent)((Object)component)).setBindAddresses((String)MiloServerComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "buildinfo": {
                ((MiloServerComponent)((Object)component)).setBuildInfo((BuildInfo)MiloServerComponentConfigurer.property((CamelContext)camelContext, BuildInfo.class, (Object)value));
                return true;
            }
            case "servercertificate": {
                ((MiloServerComponent)((Object)component)).setServerCertificate((KeyStoreLoader.Result)MiloServerComponentConfigurer.property((CamelContext)camelContext, KeyStoreLoader.Result.class, (Object)value));
                return true;
            }
            case "certificatemanager": {
                ((MiloServerComponent)((Object)component)).setCertificateManager((CertificateManager)MiloServerComponentConfigurer.property((CamelContext)camelContext, CertificateManager.class, (Object)value));
                return true;
            }
            case "certificatevalidator": {
                ((MiloServerComponent)((Object)component)).setCertificateValidator((Supplier)MiloServerComponentConfigurer.property((CamelContext)camelContext, Supplier.class, (Object)value));
                return true;
            }
            case "defaultcertificatevalidator": {
                ((MiloServerComponent)((Object)component)).setDefaultCertificateValidator((File)MiloServerComponentConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((MiloServerComponent)((Object)component)).setBasicPropertyBinding((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((MiloServerComponent)((Object)component)).setLazyStartProducer((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((MiloServerComponent)((Object)component)).setBridgeErrorHandler((Boolean)MiloServerComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

