/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.FileUtil;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteBuilder;
import org.dizitart.no2.PersistentCollection;

@Component(value="nitrite")
public class NitriteComponent
extends DefaultComponent {
    private Map<String, Nitrite> databaseCache = new ConcurrentHashMap<String, Nitrite>();
    private Map<CollectionCacheKey, PersistentCollection> collectionCache = new ConcurrentHashMap<CollectionCacheKey, PersistentCollection>();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        NitriteEndpoint endpoint = new NitriteEndpoint(uri, this);
        this.setProperties((Object)endpoint, parameters);
        if (endpoint.getCollection() != null && endpoint.getRepositoryClass() != null) {
            throw new IllegalArgumentException("Options collection and repositoryClass cannot be used together");
        }
        if (endpoint.getCollection() == null && endpoint.getRepositoryClass() == null) {
            throw new IllegalArgumentException("Either collection or repositoryClass option is required");
        }
        String normalizedPath = FileUtil.compactPath((String)remaining);
        endpoint.setDatabase(normalizedPath);
        Nitrite nitriteDatabase = this.databaseCache.computeIfAbsent(normalizedPath, path -> {
            NitriteBuilder builder = Nitrite.builder().compressed().filePath(path);
            if (endpoint.getUsername() == null && endpoint.getPassword() == null) {
                return builder.openOrCreate();
            }
            return builder.openOrCreate(endpoint.getUsername(), endpoint.getPassword());
        });
        endpoint.setNitriteDatabase(nitriteDatabase);
        PersistentCollection nitriteCollection = this.collectionCache.computeIfAbsent(new CollectionCacheKey(endpoint), key -> {
            if (key.collection != null) {
                return key.database.getCollection(key.collection);
            }
            if (key.repositoryName != null) {
                return key.database.getRepository(key.repositoryName, key.repositoryClass);
            }
            if (key.repositoryClass != null) {
                return key.database.getRepository(key.repositoryClass);
            }
            throw new IllegalArgumentException("Required one of option: collection or repositoryClass");
        });
        endpoint.setNitriteCollection(nitriteCollection);
        return endpoint;
    }

    protected void closeDb(String path) {
        String normalized = FileUtil.compactPath((String)path);
        Nitrite db = this.databaseCache.get(normalized);
        if (db != null && !db.isClosed()) {
            db.close();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (String path : this.databaseCache.keySet()) {
            this.closeDb(path);
        }
        this.databaseCache.clear();
        this.collectionCache.clear();
    }

    private static class CollectionCacheKey {
        Nitrite database;
        String collection;
        String repositoryName;
        Class<?> repositoryClass;

        CollectionCacheKey(NitriteEndpoint endpoint) {
            this.database = endpoint.getNitriteDatabase();
            this.collection = endpoint.getCollection();
            this.repositoryName = endpoint.getRepositoryName();
            this.repositoryClass = endpoint.getRepositoryClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionCacheKey that = (CollectionCacheKey)o;
            return this.database.equals(that.database) && Objects.equals(this.collection, that.collection) && Objects.equals(this.repositoryName, that.repositoryName) && Objects.equals(this.repositoryClass, that.repositoryClass);
        }

        public int hashCode() {
            return Objects.hash(this.database, this.collection, this.repositoryName, this.repositoryClass);
        }
    }
}

