/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.wordpress.WordpressComponent;
import org.apache.camel.component.wordpress.WordpressComponentConfiguration;
import org.apache.camel.component.wordpress.api.WordpressAPIConfiguration;
import org.apache.camel.component.wordpress.api.WordpressServiceProvider;
import org.apache.camel.component.wordpress.api.auth.WordpressBasicAuthentication;
import org.apache.camel.component.wordpress.api.model.SearchCriteria;
import org.apache.camel.component.wordpress.consumer.WordpressPostConsumer;
import org.apache.camel.component.wordpress.consumer.WordpressUserConsumer;
import org.apache.camel.component.wordpress.producer.WordpressPostProducer;
import org.apache.camel.component.wordpress.producer.WordpressUserProducer;
import org.apache.camel.component.wordpress.proxy.WordpressOperationType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;

@UriEndpoint(firstVersion="2.21.0", scheme="wordpress", title="Wordpress", syntax="wordpress:operation", label="cms")
public class WordpressEndpoint
extends DefaultEndpoint {
    public static final String ENDPOINT_SERVICE_POST = "post, user";
    @UriPath(description="The endpoint operation.", enums="post, user")
    @Metadata(required=true)
    private String operation;
    @UriPath(description="The second part of an endpoint operation. Needed only when endpoint semantic is not enough, like wordpress:post:delete", enums="delete")
    private String operationDetail;
    @UriParam
    private WordpressComponentConfiguration configuration;

    public WordpressEndpoint(String uri, WordpressComponent component, WordpressComponentConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public WordpressComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperationDetail() {
        return this.operationDetail;
    }

    public void setOperationDetail(String operationDetail) {
        this.operationDetail = operationDetail;
    }

    public Producer createProducer() throws Exception {
        switch (WordpressOperationType.valueOf(this.operation)) {
            case post: {
                return new WordpressPostProducer(this);
            }
            case user: {
                return new WordpressUserProducer(this);
            }
        }
        throw new UnsupportedOperationException(String.format("Operation '%s' not supported.", this.operation));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        switch (WordpressOperationType.valueOf(this.operation)) {
            case post: {
                return new WordpressPostConsumer(this, processor);
            }
            case user: {
                return new WordpressUserConsumer(this, processor);
            }
        }
        throw new UnsupportedOperationException(String.format("Operation '%s' not supported.", this.operation));
    }

    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        try {
            if (this.configuration == null) {
                this.configuration = new WordpressComponentConfiguration();
            }
            PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)this.configuration, options);
            if (this.configuration.getSearchCriteria() == null) {
                SearchCriteria searchCriteria = WordpressOperationType.valueOf(this.operation).getCriteriaType().newInstance();
                Map<String, Object> criteriaOptions = PropertiesHelper.extractProperties(options, (String)"criteria.");
                criteriaOptions = criteriaOptions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                    if (e.toString().contains(",")) {
                        return Arrays.asList(e.toString().split(","));
                    }
                    return e.getValue();
                }));
                PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)searchCriteria, criteriaOptions);
                this.configuration.setSearchCriteria(searchCriteria);
            }
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
        this.configuration.validate();
        this.initServiceProvider();
    }

    private void initServiceProvider() {
        WordpressAPIConfiguration apiConfiguration = new WordpressAPIConfiguration(this.configuration.getUrl(), this.configuration.getApiVersion());
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getUser())) {
            apiConfiguration.setAuthentication(new WordpressBasicAuthentication(this.configuration.getUser(), this.configuration.getPassword()));
        }
        WordpressServiceProvider.getInstance().init(apiConfiguration);
    }
}

