/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.msk;

import com.amazonaws.Protocol;
import com.amazonaws.services.kafka.AWSKafka;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.msk.MSKEndpoint;
import org.apache.camel.component.aws.msk.MSKOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class MSKEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return MSKEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return MSKEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "mskClient": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setMskClient((AWSKafka)MSKEndpointConfigurer.property((CamelContext)camelContext, AWSKafka.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setOperation((MSKOperations)((Object)MSKEndpointConfigurer.property((CamelContext)camelContext, MSKOperations.class, (Object)value)));
                return true;
            }
            case "proxyProtocol": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)MSKEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((MSKEndpoint)((Object)endpoint)).setStartScheduler((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((MSKEndpoint)((Object)endpoint)).setInitialDelay((Long)MSKEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((MSKEndpoint)((Object)endpoint)).setDelay((Long)MSKEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((MSKEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)MSKEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((MSKEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((MSKEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)MSKEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((MSKEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)MSKEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((MSKEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((MSKEndpoint)((Object)endpoint)).setGreedy((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((MSKEndpoint)((Object)endpoint)).setScheduler((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((MSKEndpoint)((Object)endpoint)).setSchedulerProperties((Map)MSKEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((MSKEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)MSKEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((MSKEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((MSKEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((MSKEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((MSKEndpoint)((Object)endpoint)).setRepeatCount((Long)MSKEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((MSKEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((MSKEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((MSKEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)MSKEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((MSKEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)MSKEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((MSKEndpoint)((Object)endpoint)).setSynchronous((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((MSKEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "mskclient": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setMskClient((AWSKafka)MSKEndpointConfigurer.property((CamelContext)camelContext, AWSKafka.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setOperation((MSKOperations)((Object)MSKEndpointConfigurer.property((CamelContext)camelContext, MSKOperations.class, (Object)value)));
                return true;
            }
            case "proxyprotocol": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)MSKEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((MSKEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((MSKEndpoint)((Object)endpoint)).setStartScheduler((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((MSKEndpoint)((Object)endpoint)).setInitialDelay((Long)MSKEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((MSKEndpoint)((Object)endpoint)).setDelay((Long)MSKEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((MSKEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)MSKEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((MSKEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((MSKEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)MSKEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((MSKEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)MSKEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((MSKEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((MSKEndpoint)((Object)endpoint)).setGreedy((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((MSKEndpoint)((Object)endpoint)).setScheduler((String)MSKEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((MSKEndpoint)((Object)endpoint)).setSchedulerProperties((Map)MSKEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((MSKEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)MSKEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((MSKEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((MSKEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((MSKEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)MSKEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((MSKEndpoint)((Object)endpoint)).setRepeatCount((Long)MSKEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((MSKEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((MSKEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((MSKEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)MSKEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((MSKEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)MSKEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((MSKEndpoint)((Object)endpoint)).setSynchronous((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((MSKEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)MSKEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

