/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.msk;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kafka.AWSKafka;
import com.amazonaws.services.kafka.AWSKafkaClientBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.msk.MSKConfiguration;
import org.apache.camel.component.aws.msk.MSKProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.0.0", scheme="aws-msk", title="AWS MSK", syntax="aws-msk:label", producerOnly=true, label="cloud,management")
public class MSKEndpoint
extends ScheduledPollEndpoint {
    private AWSKafka mskClient;
    @UriParam
    private MSKConfiguration configuration;

    public MSKEndpoint(String uri, Component component, MSKConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new MSKProducer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.mskClient = this.configuration.getMskClient() != null ? this.configuration.getMskClient() : this.createMSKClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getMskClient()) && this.mskClient != null) {
            this.mskClient.shutdown();
        }
        super.doStop();
    }

    public MSKConfiguration getConfiguration() {
        return this.configuration;
    }

    public AWSKafka getMskClient() {
        return this.mskClient;
    }

    AWSKafka createMSKClient() {
        AWSKafka client = null;
        ClientConfiguration clientConfiguration = null;
        AWSKafkaClientBuilder clientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyProtocol(this.configuration.getProxyProtocol());
            clientConfiguration.setProxyHost(this.configuration.getProxyHost());
            clientConfiguration.setProxyPort(this.configuration.getProxyPort().intValue());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
            clientBuilder = isClientConfigFound ? (AWSKafkaClientBuilder)((AWSKafkaClientBuilder)AWSKafkaClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)credentialsProvider) : (AWSKafkaClientBuilder)AWSKafkaClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        } else {
            clientBuilder = isClientConfigFound ? AWSKafkaClientBuilder.standard() : (AWSKafkaClientBuilder)AWSKafkaClientBuilder.standard().withClientConfiguration(clientConfiguration);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (AWSKafkaClientBuilder)clientBuilder.withRegion(Regions.valueOf((String)this.configuration.getRegion()));
        }
        client = (AWSKafka)clientBuilder.build();
        return client;
    }
}

