/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddbstream.springboot;

import com.amazonaws.Protocol;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.model.ShardIteratorType;
import org.apache.camel.component.aws.ddbstream.DdbStreamConfiguration;
import org.apache.camel.component.aws.ddbstream.SequenceNumberProvider;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.component.aws-ddbstream")
public class DdbStreamComponentConfiguration
extends ComponentConfigurationPropertiesCommon {
    private Boolean enabled;
    private DdbStreamConfigurationNestedConfiguration configuration;
    private String accessKey;
    private String secretKey;
    private String region;
    private Boolean basicPropertyBinding = false;
    private Boolean lazyStartProducer = false;
    private Boolean bridgeErrorHandler = false;

    public DdbStreamConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DdbStreamConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getBasicPropertyBinding() {
        return this.basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public Boolean getLazyStartProducer() {
        return this.lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public static class DdbStreamConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = DdbStreamConfiguration.class;
        private AmazonDynamoDBStreams amazonDynamoDbStreamsClient;
        private String accessKey;
        private String secretKey;
        private String region;
        private Integer maxResultsPerRequest;
        private String tableName;
        private ShardIteratorType iteratorType = ShardIteratorType.LATEST;
        private SequenceNumberProvider sequenceNumberProvider;
        private Protocol proxyProtocol = Protocol.HTTPS;
        private String proxyHost;
        private Integer proxyPort;

        public AmazonDynamoDBStreams getAmazonDynamoDbStreamsClient() {
            return this.amazonDynamoDbStreamsClient;
        }

        public void setAmazonDynamoDbStreamsClient(AmazonDynamoDBStreams amazonDynamoDbStreamsClient) {
            this.amazonDynamoDbStreamsClient = amazonDynamoDbStreamsClient;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public Integer getMaxResultsPerRequest() {
            return this.maxResultsPerRequest;
        }

        public void setMaxResultsPerRequest(Integer maxResultsPerRequest) {
            this.maxResultsPerRequest = maxResultsPerRequest;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public ShardIteratorType getIteratorType() {
            return this.iteratorType;
        }

        public void setIteratorType(ShardIteratorType iteratorType) {
            this.iteratorType = iteratorType;
        }

        public SequenceNumberProvider getSequenceNumberProvider() {
            return this.sequenceNumberProvider;
        }

        public void setSequenceNumberProvider(SequenceNumberProvider sequenceNumberProvider) {
            this.sequenceNumberProvider = sequenceNumberProvider;
        }

        public Protocol getProxyProtocol() {
            return this.proxyProtocol;
        }

        public void setProxyProtocol(Protocol proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }
    }
}

