/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.component.aws.sns.SnsEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.URISupport;

public class SnsProducer
extends DefaultProducer {
    private transient String snsProducerToString;

    public SnsProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        PublishRequest request = new PublishRequest();
        request.setTopicArn(this.getConfiguration().getTopicArn());
        request.setSubject(this.determineSubject(exchange));
        request.setMessageStructure(this.determineMessageStructure(exchange));
        request.setMessage((String)exchange.getIn().getBody(String.class));
        request.setMessageAttributes(this.translateAttributes(exchange.getIn().getHeaders(), exchange));
        this.log.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        PublishResult result = this.getEndpoint().getSNSClient().publish(request);
        this.log.trace("Received result [{}]", (Object)result);
        Message message = SnsProducer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsSnsMessageId", (Object)result.getMessageId());
    }

    private String determineSubject(Exchange exchange) {
        String subject = (String)exchange.getIn().getHeader("CamelAwsSnsSubject", String.class);
        if (subject == null) {
            subject = this.getConfiguration().getSubject();
        }
        return subject;
    }

    private String determineMessageStructure(Exchange exchange) {
        String structure = (String)exchange.getIn().getHeader("CamelAwsSnsMessageStructure", String.class);
        if (structure == null) {
            structure = this.getConfiguration().getMessageStructure();
        }
        return structure;
    }

    Map<String, MessageAttributeValue> translateAttributes(Map<String, Object> headers, Exchange exchange) {
        HashMap<String, MessageAttributeValue> result = new HashMap<String, MessageAttributeValue>();
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            MessageAttributeValue mav;
            if (headerFilterStrategy.applyFilterToCamelHeaders(entry.getKey(), entry.getValue(), exchange)) continue;
            Object value = entry.getValue();
            if (value instanceof String && !((String)value).isEmpty()) {
                mav = new MessageAttributeValue();
                mav.setDataType("String");
                mav.withStringValue((String)value);
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof ByteBuffer) {
                mav = new MessageAttributeValue();
                mav.setDataType("Binary");
                mav.withBinaryValue((ByteBuffer)value);
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof Date) {
                mav = new MessageAttributeValue();
                mav.setDataType("String");
                mav.withStringValue(value.toString());
                result.put(entry.getKey(), mav);
                continue;
            }
            if (value instanceof List) {
                String resultString = ((List)value).stream().map(o -> o instanceof String ? String.format("\"%s\"", o) : Objects.toString(o)).collect(Collectors.joining(", "));
                MessageAttributeValue mav2 = new MessageAttributeValue();
                mav2.setDataType("String.Array");
                mav2.withStringValue("[" + resultString + "]");
                result.put(entry.getKey(), mav2);
                continue;
            }
            this.log.warn("Cannot put the message header key={}, value={} into Sns MessageAttribute", (Object)entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected SnsConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.snsProducerToString == null) {
            this.snsProducerToString = "SnsProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.snsProducerToString;
    }

    public SnsEndpoint getEndpoint() {
        return (SnsEndpoint)super.getEndpoint();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }
}

