/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.mllp;

import org.apache.camel.component.mllp.internal.Hl7Util;

public class Hl7AcknowledgementGenerationException
extends Exception {
    private final byte[] hl7MessageBytes;

    public Hl7AcknowledgementGenerationException(String message) {
        super(message);
        this.hl7MessageBytes = null;
    }

    public Hl7AcknowledgementGenerationException(String message, byte[] hl7MessageBytes) {
        super(message);
        this.hl7MessageBytes = hl7MessageBytes;
    }

    public Hl7AcknowledgementGenerationException(String message, byte[] hl7MessageBytes, Throwable cause) {
        super(message, cause);
        this.hl7MessageBytes = hl7MessageBytes;
    }

    public boolean hasHl7MessageBytes() {
        return this.hl7MessageBytes != null && this.hl7MessageBytes.length > 0;
    }

    public byte[] getHl7MessageBytes() {
        return this.hl7MessageBytes;
    }

    @Override
    public String getMessage() {
        if (this.hasHl7MessageBytes()) {
            String parentMessage = super.getMessage();
            StringBuilder messageBuilder = new StringBuilder(parentMessage.length() + this.hl7MessageBytes.length);
            messageBuilder.append(parentMessage).append("\n\t{hl7MessageBytes [").append(this.hl7MessageBytes.length).append("] = ");
            Hl7Util.appendBytesAsPrintFriendlyString(messageBuilder, this.hl7MessageBytes, 0, this.hl7MessageBytes.length);
            messageBuilder.append('}');
            return messageBuilder.toString();
        }
        return super.getMessage();
    }
}

