/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.component.xquery.ResultFormat;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.xml.BytesSource;
import org.apache.camel.util.xml.StringSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public abstract class XQueryBuilder
implements Expression,
Predicate,
NamespaceAware,
Processor {
    private static final Logger LOG = LoggerFactory.getLogger(XQueryBuilder.class);
    private Configuration configuration;
    private Map<String, Object> configurationProperties = new HashMap<String, Object>();
    private XQueryExpression expression;
    private StaticQueryContext staticQueryContext;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, String> namespacePrefixes = new HashMap<String, String>();
    private ResultFormat resultsFormat = ResultFormat.DOM;
    private Properties properties = new Properties();
    private Class<?> resultType;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private boolean stripsAllWhiteSpace = true;
    private ModuleURIResolver moduleURIResolver;
    private boolean allowStAX;
    private String headerName;

    public String toString() {
        return "XQuery[" + this.expression + "]";
    }

    public void process(Exchange exchange) throws Exception {
        Object body = this.evaluate(exchange);
        exchange.getOut().setBody(body);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object result = this.evaluate(exchange);
        return (T)exchange.getContext().getTypeConverter().convertTo(type, result);
    }

    public Object evaluate(Exchange exchange) {
        try {
            LOG.debug("Evaluation: {} for exchange: {}", (Object)this.expression, (Object)exchange);
            if (this.resultType != null) {
                if (this.resultType.equals(String.class)) {
                    return this.evaluateAsString(exchange);
                }
                if (this.resultType.isAssignableFrom(Collection.class)) {
                    return this.evaluateAsList(exchange);
                }
                if (this.resultType.isAssignableFrom(Node.class)) {
                    return this.evaluateAsDOM(exchange);
                }
                throw new IllegalArgumentException("ResultType: " + this.resultType.getCanonicalName() + " not supported");
            }
            switch (this.resultsFormat) {
                case Bytes: {
                    return this.evaluateAsBytes(exchange);
                }
                case BytesSource: {
                    return this.evaluateAsBytesSource(exchange);
                }
                case DOM: {
                    return this.evaluateAsDOM(exchange);
                }
                case List: {
                    return this.evaluateAsList(exchange);
                }
                case StringSource: {
                    return this.evaluateAsStringSource(exchange);
                }
            }
            return this.evaluateAsString(exchange);
        }
        catch (Exception e) {
            throw new RuntimeExpressionException((Throwable)e);
        }
    }

    public List<?> evaluateAsList(Exchange exchange) throws Exception {
        LOG.debug("evaluateAsList: {} for exchange: {}", (Object)this.expression, (Object)exchange);
        this.initialize(exchange);
        return this.getExpression().evaluate(this.createDynamicContext(exchange));
    }

    public Object evaluateAsStringSource(Exchange exchange) throws Exception {
        LOG.debug("evaluateAsString: {} for exchange: {}", (Object)this.expression, (Object)exchange);
        this.initialize(exchange);
        String text = this.evaluateAsString(exchange);
        return new StringSource(text);
    }

    public Object evaluateAsBytesSource(Exchange exchange) throws Exception {
        LOG.debug("evaluateAsBytesSource: {} for exchange: {}", (Object)this.expression, (Object)exchange);
        this.initialize(exchange);
        byte[] bytes = this.evaluateAsBytes(exchange);
        return new BytesSource(bytes);
    }

    public Node evaluateAsDOM(Exchange exchange) throws Exception {
        LOG.debug("evaluateAsDOM: {} for exchange: {}", (Object)this.expression, (Object)exchange);
        this.initialize(exchange);
        DOMResult result = new DOMResult();
        DynamicQueryContext context = this.createDynamicContext(exchange);
        XQueryExpression expression = this.getExpression();
        expression.pull(context, (Result)result, this.properties);
        return result.getNode();
    }

    public byte[] evaluateAsBytes(Exchange exchange) throws Exception {
        LOG.debug("evaluateAsBytes: {} for exchange: {}", (Object)this.expression, (Object)exchange);
        this.initialize(exchange);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        this.getExpression().pull(this.createDynamicContext(exchange), (Result)result, this.properties);
        byte[] answer = buffer.toByteArray();
        buffer.close();
        return answer;
    }

    public String evaluateAsString(Exchange exchange) throws Exception {
        LOG.debug("evaluateAsString: {} for exchange: {}", (Object)this.expression, (Object)exchange);
        this.initialize(exchange);
        StringWriter buffer = new StringWriter();
        SequenceIterator iter = this.getExpression().iterator(this.createDynamicContext(exchange));
        Item item = iter.next();
        while (item != null) {
            buffer.append(item.getStringValueCS());
            item = iter.next();
        }
        String answer = buffer.toString();
        buffer.close();
        return answer;
    }

    public boolean matches(Exchange exchange) {
        LOG.debug("Matches: {} for exchange: {}", (Object)this.expression, (Object)exchange);
        try {
            List<?> list = this.evaluateAsList(exchange);
            return this.matches(exchange, list);
        }
        catch (Exception e) {
            throw new RuntimeExpressionException((Throwable)e);
        }
    }

    @Deprecated
    public void assertMatches(String text, Exchange exchange) throws AssertionError {
        List<?> list;
        try {
            list = this.evaluateAsList(exchange);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        if (!this.matches(exchange, list)) {
            throw new AssertionError((Object)(this + " failed on " + exchange + " as evaluated: " + list));
        }
    }

    public static XQueryBuilder xquery(final String queryText) {
        return new XQueryBuilder(){

            @Override
            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException {
                return staticQueryContext.compileQuery(queryText);
            }
        };
    }

    public static XQueryBuilder xquery(final Reader reader) {
        return new XQueryBuilder(){

            @Override
            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException, IOException {
                try {
                    XQueryExpression xQueryExpression = staticQueryContext.compileQuery(reader);
                    return xQueryExpression;
                }
                finally {
                    IOHelper.close((Closeable)reader);
                }
            }
        };
    }

    public static XQueryBuilder xquery(final InputStream in, final String characterSet) {
        return new XQueryBuilder(){

            @Override
            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException {
                try {
                    XQueryExpression xQueryExpression = staticQueryContext.compileQuery(in, characterSet);
                    return xQueryExpression;
                }
                finally {
                    IOHelper.close((Closeable)in);
                }
            }
        };
    }

    public static XQueryBuilder xquery(final InputStream in) {
        return new XQueryBuilder(){

            @Override
            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException {
                try {
                    XQueryExpression xQueryExpression = staticQueryContext.compileQuery(in, ObjectHelper.getDefaultCharacterSet());
                    return xQueryExpression;
                }
                finally {
                    IOHelper.close((Closeable)in);
                }
            }
        };
    }

    public XQueryBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public XQueryBuilder namespace(String prefix, String uri) {
        this.namespacePrefixes.put(prefix, uri);
        this.initialized.set(false);
        return this;
    }

    public XQueryBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    public XQueryBuilder asBytes() {
        this.setResultsFormat(ResultFormat.Bytes);
        return this;
    }

    public XQueryBuilder asBytesSource() {
        this.setResultsFormat(ResultFormat.BytesSource);
        return this;
    }

    public XQueryBuilder asDOM() {
        this.setResultsFormat(ResultFormat.DOM);
        return this;
    }

    public XQueryBuilder asDOMSource() {
        this.setResultsFormat(ResultFormat.DOMSource);
        return this;
    }

    public XQueryBuilder asList() {
        this.setResultsFormat(ResultFormat.List);
        return this;
    }

    public XQueryBuilder asString() {
        this.setResultsFormat(ResultFormat.String);
        return this;
    }

    public XQueryBuilder asStringSource() {
        this.setResultsFormat(ResultFormat.StringSource);
        return this;
    }

    public XQueryBuilder stripsAllWhiteSpace() {
        this.setStripsAllWhiteSpace(true);
        return this;
    }

    public XQueryBuilder stripsIgnorableWhiteSpace() {
        this.setStripsAllWhiteSpace(false);
        return this;
    }

    public XQueryBuilder allowStAX() {
        this.setAllowStAX(true);
        return this;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespacePrefixes.putAll(namespaces);
        this.initialized.set(false);
    }

    public Map<String, String> getNamespaces() {
        return this.namespacePrefixes;
    }

    public XQueryExpression getExpression() throws IOException, XPathException {
        return this.expression;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.initialized.set(false);
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Map<String, Object> configurationProperties) {
        this.configurationProperties = Collections.unmodifiableMap(new HashMap<String, Object>(configurationProperties));
        this.initialized.set(false);
    }

    public StaticQueryContext getStaticQueryContext() {
        return this.staticQueryContext;
    }

    public void setStaticQueryContext(StaticQueryContext staticQueryContext) {
        this.staticQueryContext = staticQueryContext;
        this.initialized.set(false);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ResultFormat getResultsFormat() {
        return this.resultsFormat;
    }

    public void setResultsFormat(ResultFormat resultsFormat) {
        this.resultsFormat = resultsFormat;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsAllWhiteSpace;
    }

    public void setStripsAllWhiteSpace(boolean stripsAllWhiteSpace) {
        this.stripsAllWhiteSpace = stripsAllWhiteSpace;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isAllowStAX() {
        return this.allowStAX;
    }

    public void setAllowStAX(boolean allowStAX) {
        this.allowStAX = allowStAX;
    }

    protected abstract XQueryExpression createQueryExpression(StaticQueryContext var1) throws XPathException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DynamicQueryContext createDynamicContext(Exchange exchange) throws Exception {
        Configuration config = this.getConfiguration();
        DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(config);
        Message in = exchange.getIn();
        Item item = null;
        item = ObjectHelper.isNotEmpty((Object)this.getHeaderName()) ? (Item)in.getHeader(this.getHeaderName(), Item.class) : (Item)in.getBody(Item.class);
        if (item != null) {
            dynamicQueryContext.setContextItem(item);
        } else {
            Object body = ObjectHelper.isNotEmpty((Object)this.getHeaderName()) ? in.getHeader(this.getHeaderName()) : in.getBody();
            InputStream is = null;
            try {
                Source source;
                if (this.isInputStreamNeeded(exchange)) {
                    is = ObjectHelper.isNotEmpty((Object)this.getHeaderName()) ? (InputStream)exchange.getIn().getHeader(this.getHeaderName(), InputStream.class) : (InputStream)exchange.getIn().getBody(InputStream.class);
                    source = this.getSource(exchange, is);
                } else {
                    source = this.getSource(exchange, body);
                }
                if (source == null) {
                    throw new NoTypeConversionAvailableException(body, Source.class);
                }
                TreeInfo doc = config.buildDocumentTree(source);
                dynamicQueryContext.setContextItem((Item)doc.getRootNode());
            }
            catch (Throwable throwable) {
                IOHelper.close(is);
                throw throwable;
            }
            IOHelper.close((Closeable)is);
        }
        this.configureQuery(dynamicQueryContext, exchange);
        MessageHelper.resetStreamCache((Message)exchange.getIn());
        return dynamicQueryContext;
    }

    protected boolean isInputStreamNeeded(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body == null) {
            return false;
        }
        if (body instanceof Source) {
            return false;
        }
        if (body instanceof String) {
            return false;
        }
        if (body instanceof byte[]) {
            return false;
        }
        return !(body instanceof Node);
    }

    protected Source getSource(Exchange exchange, Object body) {
        if (body instanceof Source) {
            return (Source)body;
        }
        Source source = null;
        if (this.isAllowStAX()) {
            source = (Source)exchange.getContext().getTypeConverter().tryConvertTo(StAXSource.class, exchange, body);
        }
        if (source == null) {
            source = (Source)exchange.getContext().getTypeConverter().tryConvertTo(SAXSource.class, exchange, body);
        }
        if (source == null) {
            source = (Source)exchange.getContext().getTypeConverter().tryConvertTo(StreamSource.class, exchange, body);
        }
        if (source == null) {
            source = (Source)exchange.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange, body);
        }
        return source;
    }

    protected void configureQuery(DynamicQueryContext dynamicQueryContext, Exchange exchange) throws Exception {
        this.addParameters(dynamicQueryContext, exchange.getProperties());
        this.addParameters(dynamicQueryContext, exchange.getIn().getHeaders(), "in.headers.");
        dynamicQueryContext.setParameter(StructuredQName.fromClarkName((String)"in.body"), (GroundedValue)this.getAsParameter(exchange.getIn().getBody()));
        this.addParameters(dynamicQueryContext, this.getParameters());
        dynamicQueryContext.setParameter(StructuredQName.fromClarkName((String)"exchange"), (GroundedValue)this.getAsParameter(exchange));
        if (exchange.hasOut() && exchange.getPattern().isOutCapable()) {
            dynamicQueryContext.setParameter(StructuredQName.fromClarkName((String)"out.body"), (GroundedValue)this.getAsParameter(exchange.getOut().getBody()));
            this.addParameters(dynamicQueryContext, exchange.getOut().getHeaders(), "out.headers.");
        }
    }

    protected void addParameters(DynamicQueryContext dynamicQueryContext, Map<String, Object> map) {
        this.addParameters(dynamicQueryContext, map, "");
    }

    protected void addParameters(DynamicQueryContext dynamicQueryContext, Map<String, Object> map, String parameterPrefix) {
        Set<Map.Entry<String, Object>> propertyEntries = map.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            if (entry.getValue() == null) continue;
            dynamicQueryContext.setParameter(StructuredQName.fromClarkName((String)(parameterPrefix + entry.getKey())), (GroundedValue)this.getAsParameter(entry.getValue()));
        }
    }

    protected Item getAsParameter(Object value) {
        if (value instanceof String) {
            return new StringValue((CharSequence)value);
        }
        if (value instanceof Boolean) {
            return BooleanValue.get((boolean)((Boolean)value));
        }
        if (value instanceof Long) {
            return Int64Value.makeIntegerValue((long)((Long)value));
        }
        if (value instanceof BigInteger) {
            return IntegerValue.makeIntegerValue((BigInteger)((BigInteger)value));
        }
        if (value instanceof Double) {
            return DoubleValue.makeDoubleValue((double)((Double)value));
        }
        if (value instanceof Float) {
            return FloatValue.makeFloatValue((float)((Float)value).floatValue());
        }
        return new ObjectValue(value);
    }

    protected boolean matches(Exchange exchange, List<?> results) {
        return ObjectHelper.matches(results);
    }

    protected synchronized void initialize(Exchange exchange) throws XPathException, IOException {
        if (!this.initialized.get()) {
            LOG.debug("Initializing XQueryBuilder {}", (Object)this);
            if (this.configuration == null) {
                this.configuration = new Configuration();
                this.configuration.getParseOptions().setSpaceStrippingRule((SpaceStrippingRule)(this.isStripsAllWhiteSpace() ? AllElementsSpaceStrippingRule.getInstance() : IgnorableSpaceStrippingRule.getInstance()));
                LOG.debug("Created new Configuration {}", (Object)this.configuration);
            } else {
                LOG.debug("Using existing Configuration {}", (Object)this.configuration);
            }
            if (this.configurationProperties != null && !this.configurationProperties.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.configurationProperties.entrySet()) {
                    this.configuration.setConfigurationProperty(entry.getKey(), entry.getValue());
                }
            }
            this.staticQueryContext = this.getConfiguration().newStaticQueryContext();
            if (this.moduleURIResolver != null) {
                this.staticQueryContext.setModuleURIResolver(this.moduleURIResolver);
            }
            Set<Map.Entry<String, String>> entries = this.namespacePrefixes.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String prefix = entry.getKey();
                String uri = entry.getValue();
                boolean invalid = "xml".equals(prefix) || "xmlns".equals(prefix);
                if (invalid) continue;
                LOG.debug("Declaring namespace [prefix: {}, uri: {}]", (Object)prefix, (Object)uri);
                this.staticQueryContext.declareNamespace(prefix, uri);
                this.staticQueryContext.setInheritNamespaces(true);
            }
            this.expression = this.createQueryExpression(this.staticQueryContext);
            this.initialized.set(true);
        }
        exchange.setProperty("CamelSaxonConfiguration", (Object)this.configuration);
    }
}

