/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jgroups.JGroupsEndpoint;
import org.apache.camel.component.jgroups.JGroupsException;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.util.ObjectHelper;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelJGroupsReceiver
extends ReceiverAdapter {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelJGroupsReceiver.class);
    private final JGroupsEndpoint endpoint;
    private final AsyncProcessor processor;

    public CamelJGroupsReceiver(JGroupsEndpoint endpoint, Processor processor) {
        ObjectHelper.notNull((Object)((Object)endpoint), (String)"endpoint");
        ObjectHelper.notNull((Object)processor, (String)"processor");
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    public void viewAccepted(View view) {
        if (this.endpoint.isEnableViewMessages()) {
            Exchange exchange = this.endpoint.createExchange(view);
            try {
                LOG.debug("Processing view: {}", (Object)view);
                this.processor.process(exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                    }
                });
            }
            catch (Exception e) {
                throw new JGroupsException("Error in consumer while dispatching exchange containing view " + view, e);
            }
        } else {
            LOG.debug("Option enableViewMessages is set to false. Skipping processing of the view: {}", (Object)view);
        }
    }

    public void receive(Message message) {
        Exchange exchange = this.endpoint.createExchange(message);
        try {
            LOG.debug("Processing message: {}", (Object)message);
            this.processor.process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                }
            });
        }
        catch (Exception e) {
            throw new JGroupsException("Error in consumer while dispatching exchange containing message " + message, e);
        }
    }
}

