/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt.saxon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.component.xslt.saxon.XsltSaxonBuilder;
import org.apache.camel.component.xslt.saxon.XsltSaxonComponent;
import org.apache.camel.component.xslt.saxon.XsltSaxonHelper;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.EndpointHelper;

@ManagedResource(description="Managed XsltSaxonEndpoint")
@UriEndpoint(firstVersion="3.0.0", scheme="xslt-saxon", title="XSLT Saxon", syntax="xslt-saxon:resourceUri", producerOnly=true, label="core,transformation")
public class XsltSaxonEndpoint
extends XsltEndpoint {
    @UriParam(label="advanced")
    private Configuration saxonConfiguration;
    @Metadata(label="advanced")
    private Map<String, Object> saxonConfigurationProperties = new HashMap<String, Object>();
    @UriParam(label="advanced", javaType="java.lang.String")
    private List<Object> saxonExtensionFunctions;
    @UriParam(displayName="Allow StAX", defaultValue="true")
    private boolean allowStAX = true;

    public XsltSaxonEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public List<Object> getSaxonExtensionFunctions() {
        return this.saxonExtensionFunctions;
    }

    public void setSaxonExtensionFunctions(List<Object> extensionFunctions) {
        this.saxonExtensionFunctions = extensionFunctions;
    }

    public void setSaxonExtensionFunctions(String extensionFunctions) {
        this.saxonExtensionFunctions = EndpointHelper.resolveReferenceListParameter((CamelContext)this.getCamelContext(), (String)extensionFunctions, Object.class);
    }

    public Configuration getSaxonConfiguration() {
        return this.saxonConfiguration;
    }

    public void setSaxonConfiguration(Configuration saxonConfiguration) {
        this.saxonConfiguration = saxonConfiguration;
    }

    public Map<String, Object> getSaxonConfigurationProperties() {
        return this.saxonConfigurationProperties;
    }

    public void setSaxonConfigurationProperties(Map<String, Object> configurationProperties) {
        this.saxonConfigurationProperties = configurationProperties;
    }

    @ManagedAttribute(description="Whether to allow using StAX as the javax.xml.transform.Source")
    public boolean isAllowStAX() {
        return this.allowStAX;
    }

    public void setAllowStAX(boolean allowStAX) {
        this.allowStAX = allowStAX;
    }

    protected void doStart() throws Exception {
        this.setXslt(this.createXsltBuilder());
        this.setProcessor((Processor)this.getXslt());
    }

    protected XsltSaxonBuilder createXsltBuilder() throws Exception {
        CamelContext ctx = this.getCamelContext();
        ClassResolver resolver = ctx.getClassResolver();
        Injector injector = ctx.getInjector();
        this.log.debug("{} using schema resource: {}", (Object)this, (Object)this.getResourceUri());
        XsltSaxonBuilder xslt = (XsltSaxonBuilder)((Object)injector.newInstance(XsltSaxonBuilder.class));
        TransformerFactory factory = this.getTransformerFactory();
        if (factory == null) {
            if (this.getTransformerFactoryClass() == null) {
                factory = new TransformerFactoryImpl();
            } else {
                Class factoryClass = resolver.resolveMandatoryClass(this.getTransformerFactoryClass(), TransformerFactory.class, XsltSaxonComponent.class.getClassLoader());
                this.log.debug("Using TransformerFactoryClass {}", (Object)factoryClass);
                factory = (TransformerFactory)injector.newInstance(factoryClass);
            }
        }
        if (factory instanceof TransformerFactoryImpl) {
            TransformerFactoryImpl tf = (TransformerFactoryImpl)factory;
            XsltSaxonHelper.registerSaxonConfiguration(tf, this.saxonConfiguration);
            XsltSaxonHelper.registerSaxonConfigurationProperties(tf, this.saxonConfigurationProperties);
            XsltSaxonHelper.registerSaxonExtensionFunctions(tf, this.saxonExtensionFunctions);
        }
        if (factory != null) {
            this.log.debug("Using TransformerFactory {}", (Object)factory);
            xslt.setTransformerFactory(factory);
        }
        if (this.getResultHandlerFactory() != null) {
            xslt.setResultHandlerFactory(this.getResultHandlerFactory());
        }
        if (this.getErrorListener() != null) {
            xslt.errorListener(this.getErrorListener());
        }
        xslt.setFailOnNullBody(this.isFailOnNullBody());
        xslt.transformerCacheSize(this.getTransformerCacheSize());
        xslt.setUriResolver(this.getUriResolver());
        xslt.setEntityResolver(this.getEntityResolver());
        xslt.setAllowStAX(this.allowStAX);
        xslt.setDeleteOutputFile(this.isDeleteOutputFile());
        this.configureOutput(xslt, this.getOutput().name());
        if (this.getParameters() != null) {
            HashMap copy = new HashMap(this.getParameters());
            xslt.setParameters(copy);
        }
        this.loadResource(this.getResourceUri(), xslt);
        return xslt;
    }
}

