/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Comparator;
import org.apache.camel.Ordered;

public final class OrderedComparator
implements Comparator<Object> {
    private static final OrderedComparator INSTANCE = new OrderedComparator();
    private static final OrderedComparator INSTANCE_REVERSE = new OrderedComparator(true);
    private final boolean reverse;

    public OrderedComparator() {
        this(false);
    }

    public OrderedComparator(boolean reverse) {
        this.reverse = reverse;
    }

    public static OrderedComparator get() {
        return INSTANCE;
    }

    public static OrderedComparator getReverse() {
        return INSTANCE_REVERSE;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Integer num1 = 0;
        Integer num2 = 0;
        if (o1 instanceof Ordered) {
            num1 = ((Ordered)o1).getOrder();
        }
        if (o2 instanceof Ordered) {
            num2 = ((Ordered)o2).getOrder();
        }
        int answer = num1.compareTo(num2);
        return this.reverse ? -1 * answer : answer;
    }
}

