/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resilience4j;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.resilience4j.ResilienceProcessor;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.Resilience4jConfigurationCommon;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.function.Suppliers;
import org.apache.camel.util.function.ThrowingSupplier;

public class ResilienceReifier
extends ProcessorReifier<CircuitBreakerDefinition> {
    public ResilienceReifier(CircuitBreakerDefinition definition) {
        super((ProcessorDefinition)definition);
    }

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        boolean fallbackViaNetwork;
        Processor processor = this.createChildProcessor(routeContext, true);
        Processor fallback = null;
        if (((CircuitBreakerDefinition)this.definition).getOnFallback() != null) {
            fallback = ProcessorReifier.reifier((ProcessorDefinition)((CircuitBreakerDefinition)this.definition).getOnFallback()).createProcessor(routeContext);
        }
        boolean bl = fallbackViaNetwork = ((CircuitBreakerDefinition)this.definition).getOnFallback() != null && ((CircuitBreakerDefinition)this.definition).getOnFallback().isFallbackViaNetwork();
        if (fallbackViaNetwork) {
            throw new UnsupportedOperationException("camel-resilience4j does not support onFallbackViaNetwork");
        }
        Resilience4jConfigurationDefinition config = this.buildResilience4jConfiguration(routeContext.getCamelContext());
        CircuitBreakerConfig cbConfig = this.configureCircuitBreaker((Resilience4jConfigurationCommon)config);
        BulkheadConfig bhConfig = this.configureBulkHead((Resilience4jConfigurationCommon)config);
        TimeLimiterConfig tlConfig = this.configureTimeLimiter((Resilience4jConfigurationCommon)config);
        ResilienceProcessor answer = new ResilienceProcessor(cbConfig, bhConfig, tlConfig, processor, fallback);
        this.configureTimeoutExecutorService(answer, routeContext, (Resilience4jConfigurationCommon)config);
        if (config.getCircuitBreakerRef() != null) {
            CircuitBreaker cb = (CircuitBreaker)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)config.getCircuitBreakerRef(), CircuitBreaker.class);
            answer.setCircuitBreaker(cb);
        }
        return answer;
    }

    private CircuitBreakerConfig configureCircuitBreaker(Resilience4jConfigurationCommon config) {
        CircuitBreakerConfig.Builder builder = CircuitBreakerConfig.custom();
        if (config.getAutomaticTransitionFromOpenToHalfOpenEnabled() != null) {
            builder.automaticTransitionFromOpenToHalfOpenEnabled(config.getAutomaticTransitionFromOpenToHalfOpenEnabled().booleanValue());
        }
        if (config.getFailureRateThreshold() != null) {
            builder.failureRateThreshold(config.getFailureRateThreshold().floatValue());
        }
        if (config.getMinimumNumberOfCalls() != null) {
            builder.minimumNumberOfCalls(config.getMinimumNumberOfCalls().intValue());
        }
        if (config.getPermittedNumberOfCallsInHalfOpenState() != null) {
            builder.permittedNumberOfCallsInHalfOpenState(config.getPermittedNumberOfCallsInHalfOpenState().intValue());
        }
        if (config.getSlidingWindowSize() != null) {
            builder.slidingWindowSize(config.getSlidingWindowSize().intValue());
        }
        if (config.getSlidingWindowType() != null) {
            builder.slidingWindowType(CircuitBreakerConfig.SlidingWindowType.valueOf((String)config.getSlidingWindowType()));
        }
        if (config.getSlowCallDurationThreshold() != null) {
            builder.slowCallDurationThreshold(Duration.ofSeconds(config.getSlowCallDurationThreshold().intValue()));
        }
        if (config.getSlowCallRateThreshold() != null) {
            builder.slowCallRateThreshold(config.getSlowCallRateThreshold().floatValue());
        }
        if (config.getWaitDurationInOpenState() != null) {
            builder.waitDurationInOpenState(Duration.ofSeconds(config.getWaitDurationInOpenState().intValue()));
        }
        if (config.getWritableStackTraceEnabled() != null) {
            builder.writableStackTraceEnabled(config.getWritableStackTraceEnabled().booleanValue());
        }
        return builder.build();
    }

    private BulkheadConfig configureBulkHead(Resilience4jConfigurationCommon config) {
        if (config.getBulkheadEnabled() == null || !config.getBulkheadEnabled().booleanValue()) {
            return null;
        }
        BulkheadConfig.Builder builder = BulkheadConfig.custom();
        if (config.getBulkheadMaxConcurrentCalls() != null) {
            builder.maxConcurrentCalls(config.getBulkheadMaxConcurrentCalls().intValue());
        }
        if (config.getBulkheadMaxWaitDuration() != null) {
            builder.maxWaitDuration(Duration.ofMillis(config.getBulkheadMaxWaitDuration().intValue()));
        }
        return builder.build();
    }

    private TimeLimiterConfig configureTimeLimiter(Resilience4jConfigurationCommon config) {
        if (config.getTimeoutEnabled() == null || !config.getTimeoutEnabled().booleanValue()) {
            return null;
        }
        TimeLimiterConfig.Builder builder = TimeLimiterConfig.custom();
        if (config.getTimeoutDuration() != null) {
            builder.timeoutDuration(Duration.ofMillis(config.getTimeoutDuration().intValue()));
        }
        if (config.getTimeoutCancelRunningFuture() != null) {
            builder.cancelRunningFuture(config.getTimeoutCancelRunningFuture().booleanValue());
        }
        return builder.build();
    }

    private void configureTimeoutExecutorService(ResilienceProcessor processor, RouteContext routeContext, Resilience4jConfigurationCommon config) {
        if (config.getTimeoutEnabled() == null || !config.getTimeoutEnabled().booleanValue()) {
            return;
        }
        if (config.getTimeoutExecutorServiceRef() != null) {
            String ref = config.getTimeoutExecutorServiceRef();
            boolean shutdownThreadPool = false;
            ExecutorService executorService = (ExecutorService)routeContext.lookup(ref, ExecutorService.class);
            if (executorService == null) {
                executorService = ProcessorDefinitionHelper.lookupExecutorServiceRef((RouteContext)routeContext, (String)"CircuitBreaker", (Object)this.definition, (String)ref);
                shutdownThreadPool = true;
            }
            processor.setExecutorService(executorService);
            processor.setShutdownExecutorService(shutdownThreadPool);
        }
    }

    Resilience4jConfigurationDefinition buildResilience4jConfiguration(CamelContext camelContext) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.loadProperties(camelContext, properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)camelContext.getExtension(Model.class)).getResilience4jConfiguration(null), () -> (Resilience4jConfigurationDefinition)CamelContextHelper.lookup((CamelContext)camelContext, (String)"Camel", Resilience4jConfigurationDefinition.class)}));
        if (((CircuitBreakerDefinition)this.definition).getConfigurationRef() != null) {
            String ref = ((CircuitBreakerDefinition)this.definition).getConfigurationRef();
            this.loadProperties(camelContext, properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)camelContext.getExtension(Model.class)).getResilience4jConfiguration(ref), () -> (Resilience4jConfigurationDefinition)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)ref, Resilience4jConfigurationDefinition.class)}));
        }
        this.loadProperties(camelContext, properties, Optional.ofNullable(((CircuitBreakerDefinition)this.definition).getResilience4jConfiguration()));
        BeanIntrospection beanIntrospection = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        beanIntrospection.getProperties((Object)this.definition, properties, null, false);
        Resilience4jConfigurationDefinition config = new Resilience4jConfigurationDefinition();
        PropertyBindingSupport.bindProperties((CamelContext)camelContext, (Object)config, properties);
        return config;
    }

    private void loadProperties(CamelContext camelContext, Map<String, Object> properties, Optional<?> optional) {
        BeanIntrospection beanIntrospection = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        optional.ifPresent(bean -> beanIntrospection.getProperties(bean, properties, null, false));
    }
}

