/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.queue.CloudQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.azure.queue.QueueServiceEndpoint;
import org.apache.camel.component.azure.queue.QueueServiceOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class QueueServiceEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return QueueServiceEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return QueueServiceEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "azureQueueClient": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setAzureQueueClient((CloudQueue)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, CloudQueue.class, (Object)value));
                return true;
            }
            case "operation": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setOperation((QueueServiceOperations)((Object)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, QueueServiceOperations.class, (Object)value)));
                return true;
            }
            case "messageTimeToLive": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setMessageTimeToLive((Integer)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "messageVisibilityDelay": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setMessageVisibilityDelay((Integer)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "queuePrefix": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setQueuePrefix((String)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "credentials": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setCredentials((StorageCredentials)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, StorageCredentials.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((QueueServiceEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((QueueServiceEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((QueueServiceEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((QueueServiceEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((QueueServiceEndpoint)((Object)endpoint)).setSynchronous((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((QueueServiceEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "azurequeueclient": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setAzureQueueClient((CloudQueue)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, CloudQueue.class, (Object)value));
                return true;
            }
            case "operation": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setOperation((QueueServiceOperations)((Object)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, QueueServiceOperations.class, (Object)value)));
                return true;
            }
            case "messagetimetolive": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setMessageTimeToLive((Integer)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "messagevisibilitydelay": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setMessageVisibilityDelay((Integer)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "queueprefix": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setQueuePrefix((String)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "credentials": {
                ((QueueServiceEndpoint)((Object)endpoint)).getConfiguration().setCredentials((StorageCredentials)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, StorageCredentials.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((QueueServiceEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((QueueServiceEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((QueueServiceEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((QueueServiceEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((QueueServiceEndpoint)((Object)endpoint)).setSynchronous((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((QueueServiceEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)QueueServiceEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

