/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks;

import com.amazonaws.Protocol;
import com.amazonaws.services.eks.AmazonEKS;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.eks.EKSEndpoint;
import org.apache.camel.component.aws.eks.EKSOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class EKSEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return EKSEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return EKSEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "eksClient": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setEksClient((AmazonEKS)EKSEndpointConfigurer.property((CamelContext)camelContext, AmazonEKS.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setOperation((EKSOperations)((Object)EKSEndpointConfigurer.property((CamelContext)camelContext, EKSOperations.class, (Object)value)));
                return true;
            }
            case "proxyProtocol": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)EKSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((EKSEndpoint)((Object)endpoint)).setStartScheduler((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((EKSEndpoint)((Object)endpoint)).setInitialDelay((Long)EKSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((EKSEndpoint)((Object)endpoint)).setDelay((Long)EKSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((EKSEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)EKSEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((EKSEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((EKSEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)EKSEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((EKSEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)EKSEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((EKSEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((EKSEndpoint)((Object)endpoint)).setGreedy((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((EKSEndpoint)((Object)endpoint)).setScheduler((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((EKSEndpoint)((Object)endpoint)).setSchedulerProperties((Map)EKSEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((EKSEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)EKSEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((EKSEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((EKSEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((EKSEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((EKSEndpoint)((Object)endpoint)).setRepeatCount((Long)EKSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((EKSEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((EKSEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((EKSEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)EKSEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((EKSEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)EKSEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((EKSEndpoint)((Object)endpoint)).setSynchronous((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((EKSEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "eksclient": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setEksClient((AmazonEKS)EKSEndpointConfigurer.property((CamelContext)camelContext, AmazonEKS.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setOperation((EKSOperations)((Object)EKSEndpointConfigurer.property((CamelContext)camelContext, EKSOperations.class, (Object)value)));
                return true;
            }
            case "proxyprotocol": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)EKSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((EKSEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((EKSEndpoint)((Object)endpoint)).setStartScheduler((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((EKSEndpoint)((Object)endpoint)).setInitialDelay((Long)EKSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((EKSEndpoint)((Object)endpoint)).setDelay((Long)EKSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((EKSEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)EKSEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((EKSEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((EKSEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)EKSEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((EKSEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)EKSEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((EKSEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((EKSEndpoint)((Object)endpoint)).setGreedy((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((EKSEndpoint)((Object)endpoint)).setScheduler((String)EKSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((EKSEndpoint)((Object)endpoint)).setSchedulerProperties((Map)EKSEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((EKSEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)EKSEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((EKSEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((EKSEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((EKSEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)EKSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((EKSEndpoint)((Object)endpoint)).setRepeatCount((Long)EKSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((EKSEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((EKSEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((EKSEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)EKSEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((EKSEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)EKSEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((EKSEndpoint)((Object)endpoint)).setSynchronous((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((EKSEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)EKSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

