/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.smpp.springboot;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.component.smpp.SmppSplittingPolicy;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.jsmpp.session.SessionStateListener;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * To send and receive SMS using a SMSC (Short Message Service Center).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.smpp")
public class SmppComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the smpp component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the shared SmppConfiguration as configuration.
     */
    private SmppConfigurationNestedConfiguration configuration;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    private Boolean basicPropertyBinding = false;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;

    public SmppConfigurationNestedConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(
            SmppConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public static class SmppConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.smpp.SmppConfiguration.class;
        /**
         * Hostname for the SMSC server to use.
         */
        private String host = "localhost";
        /**
         * Port number for the SMSC server to use.
         */
        private Integer port = 2775;
        /**
         * The system id (username) for connecting to SMSC server.
         */
        private String systemId = "smppclient";
        /**
         * Defines the data coding according the SMPP 3.4 specification, section
         * 5.2.19. Example data encodings are: <ul> <li>0: SMSC Default
         * Alphabet</li> <li>3: Latin 1 (ISO-8859-1)</li> <li>4: Octet
         * unspecified (8-bit binary)</li> <li>8: UCS2 (ISO/IEC-10646)</li>
         * <li>13: Extended Kanji JIS(X 0212-1990)</li> </ul>
         */
        private Byte dataCoding;
        /**
         * Defines encoding of data according the SMPP 3.4 specification,
         * section 5.2.19. <ul> <li>0: SMSC Default Alphabet <li>4: 8 bit
         * Alphabet</li> <li>8: UCS2 Alphabet</li></li> </ul>
         */
        private Byte alphabet;
        /**
         * Defines the encoding scheme of the short message user data. Only for
         * SubmitSm, ReplaceSm and SubmitMulti.
         */
        private String encoding = "ISO-8859-1";
        /**
         * Defines the encoding scheme of the short message user data. Only for
         * SubmitSm, ReplaceSm and SubmitMulti.
         */
        private String password;
        /**
         * Defines the interval in milliseconds between the confidence checks.
         * The confidence check is used to test the communication path between
         * an ESME and an SMSC.
         */
        private Integer enquireLinkTimer = 5000;
        /**
         * Defines the maximum period of inactivity allowed after a transaction,
         * after which an SMPP entity may assume that the session is no longer
         * active. This timer may be active on either communicating SMPP entity
         * (i.e. SMSC or ESME).
         */
        private Integer transactionTimer = 10000;
        /**
         * This parameter is used to categorize the type of ESME (External Short
         * Message Entity) that is binding to the SMSC (max. 13 characters).
         */
        private String systemType;
        /**
         * Is used to request an SMSC delivery receipt and/or SME originated
         * acknowledgements. The following values are defined: <ul> <li>0: No
         * SMSC delivery receipt requested.</li> <li>1: SMSC delivery receipt
         * requested where final delivery outcome is success or failure.</li>
         * <li>2: SMSC delivery receipt requested where the final delivery
         * outcome is delivery failure.</li> </ul>
         */
        private Byte registeredDelivery;
        /**
         * The service type parameter can be used to indicate the SMS
         * Application service associated with the message. The following
         * generic service_types are defined: <ul> <li>CMT: Cellular
         * Messaging</li> <li>CPT: Cellular Paging</li> <li>VMN: Voice Mail
         * Notification</li> <li>VMA: Voice Mail Alerting</li> <li>WAP: Wireless
         * Application Protocol</li> <li>USSD: Unstructured Supplementary
         * Services Data</li> </ul>
         */
        private String serviceType;
        /**
         * Defines the type of number (TON) to be used in the SME originator
         * address parameters. The following TON values are defined: <ul> <li>0:
         * Unknown</li> <li>1: International</li> <li>2: National</li> <li>3:
         * Network Specific</li> <li>4: Subscriber Number</li> <li>5:
         * Alphanumeric</li> <li>6: Abbreviated</li> </ul>
         */
        private Byte sourceAddrTon;
        /**
         * Defines the type of number (TON) to be used in the SME destination
         * address parameters. Only for SubmitSm, SubmitMulti, CancelSm and
         * DataSm. The following TON values are defined: <ul> <li>0:
         * Unknown</li> <li>1: International</li> <li>2: National</li> <li>3:
         * Network Specific</li> <li>4: Subscriber Number</li> <li>5:
         * Alphanumeric</li> <li>6: Abbreviated</li> </ul>
         */
        private Byte destAddrTon;
        /**
         * Defines the numeric plan indicator (NPI) to be used in the SME
         * originator address parameters. The following NPI values are defined:
         * <ul> <li>0: Unknown</li> <li>1: ISDN (E163/E164)</li> <li>2: Data
         * (X.121)</li> <li>3: Telex (F.69)</li> <li>6: Land Mobile (E.212)</li>
         * <li>8: National</li> <li>9: Private</li> <li>10: ERMES</li> <li>13:
         * Internet (IP)</li> <li>18: WAP Client Id (to be defined by WAP
         * Forum)</li> </ul>
         */
        private Byte sourceAddrNpi;
        /**
         * Defines the type of number (TON) to be used in the SME destination
         * address parameters. Only for SubmitSm, SubmitMulti, CancelSm and
         * DataSm. The following NPI values are defined: <ul> <li>0:
         * Unknown</li> <li>1: ISDN (E163/E164)</li> <li>2: Data (X.121)</li>
         * <li>3: Telex (F.69)</li> <li>6: Land Mobile (E.212)</li> <li>8:
         * National</li> <li>9: Private</li> <li>10: ERMES</li> <li>13: Internet
         * (IP)</li> <li>18: WAP Client Id (to be defined by WAP Forum)</li>
         * </ul>
         */
        private Byte destAddrNpi;
        /**
         * The protocol id
         */
        private Byte protocolId;
        /**
         * Allows the originating SME to assign a priority level to the short
         * message. Only for SubmitSm and SubmitMulti. Four Priority Levels are
         * supported: <ul> <li>0: Level 0 (lowest) priority</li> <li>1: Level 1
         * priority</li> <li>2: Level 2 priority</li> <li>3: Level 3 (highest)
         * priority</li> </ul>
         */
        private Byte priorityFlag;
        /**
         * Used to request the SMSC to replace a previously submitted message,
         * that is still pending delivery. The SMSC will replace an existing
         * message provided that the source address, destination address and
         * service type match the same fields in the new message. The following
         * replace if present flag values are defined: <ul> <li>0: Don't
         * replace</li> <li>1: Replace</li> </ul>
         */
        private Byte replaceIfPresentFlag;
        /**
         * Defines the address of SME (Short Message Entity) which originated
         * this message.
         */
        private String sourceAddr = "1616";
        /**
         * Defines the destination SME address. For mobile terminated messages,
         * this is the directory number of the recipient MS. Only for SubmitSm,
         * SubmitMulti, CancelSm and DataSm.
         */
        private String destAddr = "1717";
        /**
         * Defines the type of number (TON) to be used in the SME. The following
         * TON values are defined: <ul> <li>0: Unknown</li> <li>1:
         * International</li> <li>2: National</li> <li>3: Network Specific</li>
         * <li>4: Subscriber Number</li> <li>5: Alphanumeric</li> <li>6:
         * Abbreviated</li> </ul>
         */
        private Byte typeOfNumber;
        /**
         * Defines the numeric plan indicator (NPI) to be used in the SME. The
         * following NPI values are defined: <ul> <li>0: Unknown</li> <li>1:
         * ISDN (E163/E164)</li> <li>2: Data (X.121)</li> <li>3: Telex
         * (F.69)</li> <li>6: Land Mobile (E.212)</li> <li>8: National</li>
         * <li>9: Private</li> <li>10: ERMES</li> <li>13: Internet (IP)</li>
         * <li>18: WAP Client Id (to be defined by WAP Forum)</li> </ul>
         */
        private Byte numberingPlanIndicator;
        /**
         * Whether using SSL with the smpps protocol
         */
        private Boolean usingSSL = false;
        /**
         * Defines the initial delay in milliseconds after the consumer/producer
         * tries to reconnect to the SMSC, after the connection was lost.
         */
        private Long initialReconnectDelay = 5000L;
        /**
         * Defines the interval in milliseconds between the reconnect attempts,
         * if the connection to the SMSC was lost and the previous was not
         * succeed.
         */
        private Long reconnectDelay = 5000L;
        /**
         * Defines the maximum number of attempts to reconnect to the SMSC, if
         * SMSC returns a negative bind response
         */
        private Integer maxReconnect = 2147483647;
        /**
         * Sessions can be lazily created to avoid exceptions, if the SMSC is
         * not available when the Camel producer is started. Camel will check
         * the in message headers 'CamelSmppSystemId' and 'CamelSmppPassword' of
         * the first exchange. If they are present, Camel will use these data to
         * connect to the SMSC.
         */
        private Boolean lazySessionCreation = false;
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the hostname or ip address of your HTTP proxy.
         */
        private String httpProxyHost;
        /**
         * If you need to tunnel SMPP through a HTTP proxy, set this attribute
         * to the port of your HTTP proxy.
         */
        private Integer httpProxyPort = 3128;
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the username required for your HTTP proxy.
         */
        private String httpProxyUsername;
        /**
         * If your HTTP proxy requires basic authentication, set this attribute
         * to the password required for your HTTP proxy.
         */
        private String httpProxyPassword;
        /**
         * You can refer to a org.jsmpp.session.SessionStateListener in the
         * Registry to receive callbacks when the session state changed.
         */
        private SessionStateListener sessionStateListener;
        /**
         * You can specify the address range for the SmppConsumer as defined in
         * section 5.2.7 of the SMPP 3.4 specification. The SmppConsumer will
         * receive messages only from SMSC's which target an address (MSISDN or
         * IP address) within this range.
         */
        private String addressRange;
        /**
         * You can specify a policy for handling long messages: <ul> <li>ALLOW -
         * the default, long messages are split to 140 bytes per message</li>
         * <li>TRUNCATE - long messages are split and only the first fragment
         * will be sent to the SMSC. Some carriers drop subsequent fragments so
         * this reduces load on the SMPP connection sending parts of a message
         * that will never be delivered.</li> <li>REJECT - if a message would
         * need to be split, it is rejected with an SMPP
         * NegativeResponseException and the reason code signifying the message
         * is too long.</li> </ul>
         */
        private SmppSplittingPolicy splittingPolicy = SmppSplittingPolicy.ALLOW;
        /**
         * These headers will be passed to the proxy server while establishing
         * the connection.
         */
        private Map proxyHeaders;

        public String getHost() {
            return host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getSystemId() {
            return systemId;
        }

        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public Byte getDataCoding() {
            return dataCoding;
        }

        public void setDataCoding(Byte dataCoding) {
            this.dataCoding = dataCoding;
        }

        public Byte getAlphabet() {
            return alphabet;
        }

        public void setAlphabet(Byte alphabet) {
            this.alphabet = alphabet;
        }

        public String getEncoding() {
            return encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getEnquireLinkTimer() {
            return enquireLinkTimer;
        }

        public void setEnquireLinkTimer(Integer enquireLinkTimer) {
            this.enquireLinkTimer = enquireLinkTimer;
        }

        public Integer getTransactionTimer() {
            return transactionTimer;
        }

        public void setTransactionTimer(Integer transactionTimer) {
            this.transactionTimer = transactionTimer;
        }

        public String getSystemType() {
            return systemType;
        }

        public void setSystemType(String systemType) {
            this.systemType = systemType;
        }

        public Byte getRegisteredDelivery() {
            return registeredDelivery;
        }

        public void setRegisteredDelivery(Byte registeredDelivery) {
            this.registeredDelivery = registeredDelivery;
        }

        public String getServiceType() {
            return serviceType;
        }

        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public Byte getSourceAddrTon() {
            return sourceAddrTon;
        }

        public void setSourceAddrTon(Byte sourceAddrTon) {
            this.sourceAddrTon = sourceAddrTon;
        }

        public Byte getDestAddrTon() {
            return destAddrTon;
        }

        public void setDestAddrTon(Byte destAddrTon) {
            this.destAddrTon = destAddrTon;
        }

        public Byte getSourceAddrNpi() {
            return sourceAddrNpi;
        }

        public void setSourceAddrNpi(Byte sourceAddrNpi) {
            this.sourceAddrNpi = sourceAddrNpi;
        }

        public Byte getDestAddrNpi() {
            return destAddrNpi;
        }

        public void setDestAddrNpi(Byte destAddrNpi) {
            this.destAddrNpi = destAddrNpi;
        }

        public Byte getProtocolId() {
            return protocolId;
        }

        public void setProtocolId(Byte protocolId) {
            this.protocolId = protocolId;
        }

        public Byte getPriorityFlag() {
            return priorityFlag;
        }

        public void setPriorityFlag(Byte priorityFlag) {
            this.priorityFlag = priorityFlag;
        }

        public Byte getReplaceIfPresentFlag() {
            return replaceIfPresentFlag;
        }

        public void setReplaceIfPresentFlag(Byte replaceIfPresentFlag) {
            this.replaceIfPresentFlag = replaceIfPresentFlag;
        }

        public String getSourceAddr() {
            return sourceAddr;
        }

        public void setSourceAddr(String sourceAddr) {
            this.sourceAddr = sourceAddr;
        }

        public String getDestAddr() {
            return destAddr;
        }

        public void setDestAddr(String destAddr) {
            this.destAddr = destAddr;
        }

        public Byte getTypeOfNumber() {
            return typeOfNumber;
        }

        public void setTypeOfNumber(Byte typeOfNumber) {
            this.typeOfNumber = typeOfNumber;
        }

        public Byte getNumberingPlanIndicator() {
            return numberingPlanIndicator;
        }

        public void setNumberingPlanIndicator(Byte numberingPlanIndicator) {
            this.numberingPlanIndicator = numberingPlanIndicator;
        }

        public Boolean getUsingSSL() {
            return usingSSL;
        }

        public void setUsingSSL(Boolean usingSSL) {
            this.usingSSL = usingSSL;
        }

        public Long getInitialReconnectDelay() {
            return initialReconnectDelay;
        }

        public void setInitialReconnectDelay(Long initialReconnectDelay) {
            this.initialReconnectDelay = initialReconnectDelay;
        }

        public Long getReconnectDelay() {
            return reconnectDelay;
        }

        public void setReconnectDelay(Long reconnectDelay) {
            this.reconnectDelay = reconnectDelay;
        }

        public Integer getMaxReconnect() {
            return maxReconnect;
        }

        public void setMaxReconnect(Integer maxReconnect) {
            this.maxReconnect = maxReconnect;
        }

        public Boolean getLazySessionCreation() {
            return lazySessionCreation;
        }

        public void setLazySessionCreation(Boolean lazySessionCreation) {
            this.lazySessionCreation = lazySessionCreation;
        }

        public String getHttpProxyHost() {
            return httpProxyHost;
        }

        public void setHttpProxyHost(String httpProxyHost) {
            this.httpProxyHost = httpProxyHost;
        }

        public Integer getHttpProxyPort() {
            return httpProxyPort;
        }

        public void setHttpProxyPort(Integer httpProxyPort) {
            this.httpProxyPort = httpProxyPort;
        }

        public String getHttpProxyUsername() {
            return httpProxyUsername;
        }

        public void setHttpProxyUsername(String httpProxyUsername) {
            this.httpProxyUsername = httpProxyUsername;
        }

        public String getHttpProxyPassword() {
            return httpProxyPassword;
        }

        public void setHttpProxyPassword(String httpProxyPassword) {
            this.httpProxyPassword = httpProxyPassword;
        }

        public SessionStateListener getSessionStateListener() {
            return sessionStateListener;
        }

        public void setSessionStateListener(
                SessionStateListener sessionStateListener) {
            this.sessionStateListener = sessionStateListener;
        }

        public String getAddressRange() {
            return addressRange;
        }

        public void setAddressRange(String addressRange) {
            this.addressRange = addressRange;
        }

        public SmppSplittingPolicy getSplittingPolicy() {
            return splittingPolicy;
        }

        public void setSplittingPolicy(SmppSplittingPolicy splittingPolicy) {
            this.splittingPolicy = splittingPolicy;
        }

        public Map getProxyHeaders() {
            return proxyHeaders;
        }

        public void setProxyHeaders(Map proxyHeaders) {
            this.proxyHeaders = proxyHeaders;
        }
    }
}