/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * To integrate with the Soroush chat bot.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SoroushBotEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Soroush component.
     */
    public interface SoroushBotEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSoroushBotEndpointConsumerBuilder advanced() {
            return (AdvancedSoroushBotEndpointConsumerBuilder) this;
        }
        /**
         * Connection timeout in ms when connecting to soroush API.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointConsumerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout in ms when connecting to soroush API.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Maximum connection retry when fail to connect to soroush API, if the
         * quota is reached, MaximumConnectionRetryReachedException is thrown
         * for that message.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointConsumerBuilder maxConnectionRetry(
                int maxConnectionRetry) {
            doSetProperty("maxConnectionRetry", maxConnectionRetry);
            return this;
        }
        /**
         * Maximum connection retry when fail to connect to soroush API, if the
         * quota is reached, MaximumConnectionRetryReachedException is thrown
         * for that message.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointConsumerBuilder maxConnectionRetry(
                String maxConnectionRetry) {
            doSetProperty("maxConnectionRetry", maxConnectionRetry);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SoroushBotEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SoroushBotEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Number of Thread created by consumer in the route. if you use this
         * method for parallelism, it is guaranteed that messages from same user
         * always execute in the same thread and therefore messages from the
         * same user are processed sequentially. Default value notice: using
         * SoroushBotSingleThreadConsumer.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default SoroushBotEndpointConsumerBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Number of Thread created by consumer in the route. if you use this
         * method for parallelism, it is guaranteed that messages from same user
         * always execute in the same thread and therefore messages from the
         * same user are processed sequentially. Default value notice: using
         * SoroushBotSingleThreadConsumer.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default SoroushBotEndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Maximum capacity of each queue when concurrentConsumers is greater
         * than 1. if a queue become full, every message that should go to that
         * queue will be dropped. If bridgeErrorHandler is set to true, an
         * exchange with CongestionException is directed to ErrorHandler. You
         * can then processed the error using
         * onException(CongestionException.class) route. Default value notice:
         * infinite capacity.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default SoroushBotEndpointConsumerBuilder queueCapacityPerThread(
                int queueCapacityPerThread) {
            doSetProperty("queueCapacityPerThread", queueCapacityPerThread);
            return this;
        }
        /**
         * Maximum capacity of each queue when concurrentConsumers is greater
         * than 1. if a queue become full, every message that should go to that
         * queue will be dropped. If bridgeErrorHandler is set to true, an
         * exchange with CongestionException is directed to ErrorHandler. You
         * can then processed the error using
         * onException(CongestionException.class) route. Default value notice:
         * infinite capacity.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default SoroushBotEndpointConsumerBuilder queueCapacityPerThread(
                String queueCapacityPerThread) {
            doSetProperty("queueCapacityPerThread", queueCapacityPerThread);
            return this;
        }
        /**
         * The authorization token for using the bot. if uri path does not
         * contain authorization token, this token will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SoroushBotEndpointConsumerBuilder authorizationToken(
                String authorizationToken) {
            doSetProperty("authorizationToken", authorizationToken);
            return this;
        }
        /**
         * The strategy to backoff in case of connection failure. Currently 3
         * strategies are supported: 1. Exponential (default): It multiply
         * retryWaitingTime by retryExponentialCoefficient after each connection
         * failure. 2. Linear: It increase retryWaitingTime by
         * retryLinearIncrement after each connection failure. 3. Fixed: Always
         * use retryWaitingTime as the time between retries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder backOffStrategy(
                String backOffStrategy) {
            doSetProperty("backOffStrategy", backOffStrategy);
            return this;
        }
        /**
         * Maximum amount of time (in millisecond) a thread wait before retrying
         * failed request.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder maxRetryWaitingTime(
                long maxRetryWaitingTime) {
            doSetProperty("maxRetryWaitingTime", maxRetryWaitingTime);
            return this;
        }
        /**
         * Maximum amount of time (in millisecond) a thread wait before retrying
         * failed request.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder maxRetryWaitingTime(
                String maxRetryWaitingTime) {
            doSetProperty("maxRetryWaitingTime", maxRetryWaitingTime);
            return this;
        }
        /**
         * The timeout in millisecond to reconnect the existing getMessage
         * connection to ensure that the connection is always live and does not
         * dead without notifying the bot. this value should not be changed.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder reconnectIdleConnectionTimeout(
                long reconnectIdleConnectionTimeout) {
            doSetProperty("reconnectIdleConnectionTimeout", reconnectIdleConnectionTimeout);
            return this;
        }
        /**
         * The timeout in millisecond to reconnect the existing getMessage
         * connection to ensure that the connection is always live and does not
         * dead without notifying the bot. this value should not be changed.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder reconnectIdleConnectionTimeout(
                String reconnectIdleConnectionTimeout) {
            doSetProperty("reconnectIdleConnectionTimeout", reconnectIdleConnectionTimeout);
            return this;
        }
        /**
         * Coefficient to compute back off time when using Exponential Back Off
         * strategy.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder retryExponentialCoefficient(
                long retryExponentialCoefficient) {
            doSetProperty("retryExponentialCoefficient", retryExponentialCoefficient);
            return this;
        }
        /**
         * Coefficient to compute back off time when using Exponential Back Off
         * strategy.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder retryExponentialCoefficient(
                String retryExponentialCoefficient) {
            doSetProperty("retryExponentialCoefficient", retryExponentialCoefficient);
            return this;
        }
        /**
         * The amount of time (in millisecond) which adds to waiting time when
         * using Linear back off strategy.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder retryLinearIncrement(
                long retryLinearIncrement) {
            doSetProperty("retryLinearIncrement", retryLinearIncrement);
            return this;
        }
        /**
         * The amount of time (in millisecond) which adds to waiting time when
         * using Linear back off strategy.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder retryLinearIncrement(
                String retryLinearIncrement) {
            doSetProperty("retryLinearIncrement", retryLinearIncrement);
            return this;
        }
        /**
         * Waiting time before retry failed request (Millisecond). If
         * backOffStrategy is not Fixed this is the based value for computing
         * back off waiting time. the first retry is always happen immediately
         * after failure and retryWaitingTime do not apply to the first retry.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder retryWaitingTime(
                long retryWaitingTime) {
            doSetProperty("retryWaitingTime", retryWaitingTime);
            return this;
        }
        /**
         * Waiting time before retry failed request (Millisecond). If
         * backOffStrategy is not Fixed this is the based value for computing
         * back off waiting time. the first retry is always happen immediately
         * after failure and retryWaitingTime do not apply to the first retry.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointConsumerBuilder retryWaitingTime(
                String retryWaitingTime) {
            doSetProperty("retryWaitingTime", retryWaitingTime);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Soroush component.
     */
    public interface AdvancedSoroushBotEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SoroushBotEndpointConsumerBuilder basic() {
            return (SoroushBotEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSoroushBotEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSoroushBotEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSoroushBotEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSoroushBotEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Soroush component.
     */
    public interface SoroushBotEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSoroushBotEndpointProducerBuilder advanced() {
            return (AdvancedSoroushBotEndpointProducerBuilder) this;
        }
        /**
         * Connection timeout in ms when connecting to soroush API.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointProducerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout in ms when connecting to soroush API.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Maximum connection retry when fail to connect to soroush API, if the
         * quota is reached, MaximumConnectionRetryReachedException is thrown
         * for that message.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointProducerBuilder maxConnectionRetry(
                int maxConnectionRetry) {
            doSetProperty("maxConnectionRetry", maxConnectionRetry);
            return this;
        }
        /**
         * Maximum connection retry when fail to connect to soroush API, if the
         * quota is reached, MaximumConnectionRetryReachedException is thrown
         * for that message.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointProducerBuilder maxConnectionRetry(
                String maxConnectionRetry) {
            doSetProperty("maxConnectionRetry", maxConnectionRetry);
            return this;
        }
        /**
         * Automatically download SoroushMessage.fileUrl and
         * SoroushMessage.thumbnailUrl if exists for the message and store them
         * in SoroushMessage.file and SoroushMessage.thumbnail field.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder autoDownload(
                boolean autoDownload) {
            doSetProperty("autoDownload", autoDownload);
            return this;
        }
        /**
         * Automatically download SoroushMessage.fileUrl and
         * SoroushMessage.thumbnailUrl if exists for the message and store them
         * in SoroushMessage.file and SoroushMessage.thumbnail field.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder autoDownload(
                String autoDownload) {
            doSetProperty("autoDownload", autoDownload);
            return this;
        }
        /**
         * Automatically upload attachments when a message goes to the
         * sendMessage endpoint and the SoroushMessage.file
         * (SoroushMessage.thumbnail) has been set and
         * SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl) is null.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder autoUploadFile(
                boolean autoUploadFile) {
            doSetProperty("autoUploadFile", autoUploadFile);
            return this;
        }
        /**
         * Automatically upload attachments when a message goes to the
         * sendMessage endpoint and the SoroushMessage.file
         * (SoroushMessage.thumbnail) has been set and
         * SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl) is null.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder autoUploadFile(
                String autoUploadFile) {
            doSetProperty("autoUploadFile", autoUploadFile);
            return this;
        }
        /**
         * If true, when downloading an attached file, thumbnail will be
         * downloaded if provided in the message. Otherwise, only the file will
         * be downloaded.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder downloadThumbnail(
                boolean downloadThumbnail) {
            doSetProperty("downloadThumbnail", downloadThumbnail);
            return this;
        }
        /**
         * If true, when downloading an attached file, thumbnail will be
         * downloaded if provided in the message. Otherwise, only the file will
         * be downloaded.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder downloadThumbnail(
                String downloadThumbnail) {
            doSetProperty("downloadThumbnail", downloadThumbnail);
            return this;
        }
        /**
         * Force to download SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl)
         * if exists, even if the SoroushMessage.file(SoroushMessage.thumbnail)
         * was not null in that message.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder forceDownload(
                boolean forceDownload) {
            doSetProperty("forceDownload", forceDownload);
            return this;
        }
        /**
         * Force to download SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl)
         * if exists, even if the SoroushMessage.file(SoroushMessage.thumbnail)
         * was not null in that message.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder forceDownload(
                String forceDownload) {
            doSetProperty("forceDownload", forceDownload);
            return this;
        }
        /**
         * Force to upload SoroushMessage.file(SoroushMessage.thumbnail) if
         * exists, even if the
         * SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl) is not null in
         * the message.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder forceUpload(
                boolean forceUpload) {
            doSetProperty("forceUpload", forceUpload);
            return this;
        }
        /**
         * Force to upload SoroushMessage.file(SoroushMessage.thumbnail) if
         * exists, even if the
         * SoroushMessage.fileUrl(SoroushMessage.thumbnailUrl) is not null in
         * the message.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder forceUpload(String forceUpload) {
            doSetProperty("forceUpload", forceUpload);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SoroushBotEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The authorization token for using the bot. if uri path does not
         * contain authorization token, this token will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SoroushBotEndpointProducerBuilder authorizationToken(
                String authorizationToken) {
            doSetProperty("authorizationToken", authorizationToken);
            return this;
        }
        /**
         * The strategy to backoff in case of connection failure. Currently 3
         * strategies are supported: 1. Exponential (default): It multiply
         * retryWaitingTime by retryExponentialCoefficient after each connection
         * failure. 2. Linear: It increase retryWaitingTime by
         * retryLinearIncrement after each connection failure. 3. Fixed: Always
         * use retryWaitingTime as the time between retries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder backOffStrategy(
                String backOffStrategy) {
            doSetProperty("backOffStrategy", backOffStrategy);
            return this;
        }
        /**
         * Maximum amount of time (in millisecond) a thread wait before retrying
         * failed request.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder maxRetryWaitingTime(
                long maxRetryWaitingTime) {
            doSetProperty("maxRetryWaitingTime", maxRetryWaitingTime);
            return this;
        }
        /**
         * Maximum amount of time (in millisecond) a thread wait before retrying
         * failed request.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder maxRetryWaitingTime(
                String maxRetryWaitingTime) {
            doSetProperty("maxRetryWaitingTime", maxRetryWaitingTime);
            return this;
        }
        /**
         * The timeout in millisecond to reconnect the existing getMessage
         * connection to ensure that the connection is always live and does not
         * dead without notifying the bot. this value should not be changed.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder reconnectIdleConnectionTimeout(
                long reconnectIdleConnectionTimeout) {
            doSetProperty("reconnectIdleConnectionTimeout", reconnectIdleConnectionTimeout);
            return this;
        }
        /**
         * The timeout in millisecond to reconnect the existing getMessage
         * connection to ensure that the connection is always live and does not
         * dead without notifying the bot. this value should not be changed.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder reconnectIdleConnectionTimeout(
                String reconnectIdleConnectionTimeout) {
            doSetProperty("reconnectIdleConnectionTimeout", reconnectIdleConnectionTimeout);
            return this;
        }
        /**
         * Coefficient to compute back off time when using Exponential Back Off
         * strategy.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder retryExponentialCoefficient(
                long retryExponentialCoefficient) {
            doSetProperty("retryExponentialCoefficient", retryExponentialCoefficient);
            return this;
        }
        /**
         * Coefficient to compute back off time when using Exponential Back Off
         * strategy.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder retryExponentialCoefficient(
                String retryExponentialCoefficient) {
            doSetProperty("retryExponentialCoefficient", retryExponentialCoefficient);
            return this;
        }
        /**
         * The amount of time (in millisecond) which adds to waiting time when
         * using Linear back off strategy.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder retryLinearIncrement(
                long retryLinearIncrement) {
            doSetProperty("retryLinearIncrement", retryLinearIncrement);
            return this;
        }
        /**
         * The amount of time (in millisecond) which adds to waiting time when
         * using Linear back off strategy.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder retryLinearIncrement(
                String retryLinearIncrement) {
            doSetProperty("retryLinearIncrement", retryLinearIncrement);
            return this;
        }
        /**
         * Waiting time before retry failed request (Millisecond). If
         * backOffStrategy is not Fixed this is the based value for computing
         * back off waiting time. the first retry is always happen immediately
         * after failure and retryWaitingTime do not apply to the first retry.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder retryWaitingTime(
                long retryWaitingTime) {
            doSetProperty("retryWaitingTime", retryWaitingTime);
            return this;
        }
        /**
         * Waiting time before retry failed request (Millisecond). If
         * backOffStrategy is not Fixed this is the based value for computing
         * back off waiting time. the first retry is always happen immediately
         * after failure and retryWaitingTime do not apply to the first retry.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointProducerBuilder retryWaitingTime(
                String retryWaitingTime) {
            doSetProperty("retryWaitingTime", retryWaitingTime);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Soroush component.
     */
    public interface AdvancedSoroushBotEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SoroushBotEndpointProducerBuilder basic() {
            return (SoroushBotEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Soroush component.
     */
    public interface SoroushBotEndpointBuilder
            extends
                SoroushBotEndpointConsumerBuilder, SoroushBotEndpointProducerBuilder {
        default AdvancedSoroushBotEndpointBuilder advanced() {
            return (AdvancedSoroushBotEndpointBuilder) this;
        }
        /**
         * Connection timeout in ms when connecting to soroush API.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Connection timeout in ms when connecting to soroush API.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * Maximum connection retry when fail to connect to soroush API, if the
         * quota is reached, MaximumConnectionRetryReachedException is thrown
         * for that message.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointBuilder maxConnectionRetry(
                int maxConnectionRetry) {
            doSetProperty("maxConnectionRetry", maxConnectionRetry);
            return this;
        }
        /**
         * Maximum connection retry when fail to connect to soroush API, if the
         * quota is reached, MaximumConnectionRetryReachedException is thrown
         * for that message.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SoroushBotEndpointBuilder maxConnectionRetry(
                String maxConnectionRetry) {
            doSetProperty("maxConnectionRetry", maxConnectionRetry);
            return this;
        }
        /**
         * The authorization token for using the bot. if uri path does not
         * contain authorization token, this token will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default SoroushBotEndpointBuilder authorizationToken(
                String authorizationToken) {
            doSetProperty("authorizationToken", authorizationToken);
            return this;
        }
        /**
         * The strategy to backoff in case of connection failure. Currently 3
         * strategies are supported: 1. Exponential (default): It multiply
         * retryWaitingTime by retryExponentialCoefficient after each connection
         * failure. 2. Linear: It increase retryWaitingTime by
         * retryLinearIncrement after each connection failure. 3. Fixed: Always
         * use retryWaitingTime as the time between retries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder backOffStrategy(String backOffStrategy) {
            doSetProperty("backOffStrategy", backOffStrategy);
            return this;
        }
        /**
         * Maximum amount of time (in millisecond) a thread wait before retrying
         * failed request.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder maxRetryWaitingTime(
                long maxRetryWaitingTime) {
            doSetProperty("maxRetryWaitingTime", maxRetryWaitingTime);
            return this;
        }
        /**
         * Maximum amount of time (in millisecond) a thread wait before retrying
         * failed request.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder maxRetryWaitingTime(
                String maxRetryWaitingTime) {
            doSetProperty("maxRetryWaitingTime", maxRetryWaitingTime);
            return this;
        }
        /**
         * The timeout in millisecond to reconnect the existing getMessage
         * connection to ensure that the connection is always live and does not
         * dead without notifying the bot. this value should not be changed.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder reconnectIdleConnectionTimeout(
                long reconnectIdleConnectionTimeout) {
            doSetProperty("reconnectIdleConnectionTimeout", reconnectIdleConnectionTimeout);
            return this;
        }
        /**
         * The timeout in millisecond to reconnect the existing getMessage
         * connection to ensure that the connection is always live and does not
         * dead without notifying the bot. this value should not be changed.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder reconnectIdleConnectionTimeout(
                String reconnectIdleConnectionTimeout) {
            doSetProperty("reconnectIdleConnectionTimeout", reconnectIdleConnectionTimeout);
            return this;
        }
        /**
         * Coefficient to compute back off time when using Exponential Back Off
         * strategy.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder retryExponentialCoefficient(
                long retryExponentialCoefficient) {
            doSetProperty("retryExponentialCoefficient", retryExponentialCoefficient);
            return this;
        }
        /**
         * Coefficient to compute back off time when using Exponential Back Off
         * strategy.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder retryExponentialCoefficient(
                String retryExponentialCoefficient) {
            doSetProperty("retryExponentialCoefficient", retryExponentialCoefficient);
            return this;
        }
        /**
         * The amount of time (in millisecond) which adds to waiting time when
         * using Linear back off strategy.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder retryLinearIncrement(
                long retryLinearIncrement) {
            doSetProperty("retryLinearIncrement", retryLinearIncrement);
            return this;
        }
        /**
         * The amount of time (in millisecond) which adds to waiting time when
         * using Linear back off strategy.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder retryLinearIncrement(
                String retryLinearIncrement) {
            doSetProperty("retryLinearIncrement", retryLinearIncrement);
            return this;
        }
        /**
         * Waiting time before retry failed request (Millisecond). If
         * backOffStrategy is not Fixed this is the based value for computing
         * back off waiting time. the first retry is always happen immediately
         * after failure and retryWaitingTime do not apply to the first retry.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder retryWaitingTime(long retryWaitingTime) {
            doSetProperty("retryWaitingTime", retryWaitingTime);
            return this;
        }
        /**
         * Waiting time before retry failed request (Millisecond). If
         * backOffStrategy is not Fixed this is the based value for computing
         * back off waiting time. the first retry is always happen immediately
         * after failure and retryWaitingTime do not apply to the first retry.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduling
         */
        default SoroushBotEndpointBuilder retryWaitingTime(
                String retryWaitingTime) {
            doSetProperty("retryWaitingTime", retryWaitingTime);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Soroush component.
     */
    public interface AdvancedSoroushBotEndpointBuilder
            extends
                AdvancedSoroushBotEndpointConsumerBuilder, AdvancedSoroushBotEndpointProducerBuilder {
        default SoroushBotEndpointBuilder basic() {
            return (SoroushBotEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSoroushBotEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Soroush (camel-soroush)
     * To integrate with the Soroush chat bot.
     * 
     * Category: chat
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-soroush
     * 
     * Syntax: <code>soroush:action</code>
     * 
     * Path parameter: action (required)
     * The action to do.
     * The value can be one of: sendMessage, getMessage, uploadFile,
     * downloadFile
     */
    default SoroushBotEndpointBuilder soroush(String path) {
        class SoroushBotEndpointBuilderImpl extends AbstractEndpointBuilder implements SoroushBotEndpointBuilder, AdvancedSoroushBotEndpointBuilder {
            public SoroushBotEndpointBuilderImpl(String path) {
                super("soroush", path);
            }
        }
        return new SoroushBotEndpointBuilderImpl(path);
    }
}