/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * To use Jetty as a HTTP server as consumer for Camel routes.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JettyHttpEndpointBuilder9Factory {


    /**
     * Builder for endpoint for the Jetty component.
     */
    public interface JettyHttpEndpointBuilder9
            extends
                EndpointConsumerBuilder {
        default AdvancedJettyHttpEndpointBuilder9 advanced() {
            return (AdvancedJettyHttpEndpointBuilder9) this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JettyHttpEndpointBuilder9 disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JettyHttpEndpointBuilder9 disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default JettyHttpEndpointBuilder9 headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: common
         */
        default JettyHttpEndpointBuilder9 headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Configure the consumer to work in async mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 async(boolean async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * Configure the consumer to work in async mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 async(String async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 chunked(boolean chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 chunked(String chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * Allows to set a timeout in millis when using Jetty as consumer
         * (server). By default Jetty uses 30000. You can use a value of = 0 to
         * never expire. If a timeout occurs then the request will be expired
         * and Jetty will return back a http error 503 to the client. This
         * option is only in use when using Jetty with the Asynchronous Routing
         * Engine.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 continuationTimeout(
                Long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * Allows to set a timeout in millis when using Jetty as consumer
         * (server). By default Jetty uses 30000. You can use a value of = 0 to
         * never expire. If a timeout occurs then the request will be expired
         * and Jetty will return back a http error 503 to the client. This
         * option is only in use when using Jetty with the Asynchronous Routing
         * Engine.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 continuationTimeout(
                String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * If the option is true, Jetty server will setup the CrossOriginFilter
         * which supports the CORS out of box.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 enableCORS(boolean enableCORS) {
            doSetProperty("enableCORS", enableCORS);
            return this;
        }
        /**
         * If the option is true, Jetty server will setup the CrossOriginFilter
         * which supports the CORS out of box.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 enableCORS(String enableCORS) {
            doSetProperty("enableCORS", enableCORS);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * Whether org.apache.camel.component.jetty.MultiPartFilter is enabled
         * or not. You should set this value to false when bridging endpoints,
         * to ensure multipart requests is proxied/bridged as well.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 enableMultipartFilter(
                boolean enableMultipartFilter) {
            doSetProperty("enableMultipartFilter", enableMultipartFilter);
            return this;
        }
        /**
         * Whether org.apache.camel.component.jetty.MultiPartFilter is enabled
         * or not. You should set this value to false when bridging endpoints,
         * to ensure multipart requests is proxied/bridged as well.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 enableMultipartFilter(
                String enableMultipartFilter) {
            doSetProperty("enableMultipartFilter", enableMultipartFilter);
            return this;
        }
        /**
         * Used to only allow consuming if the HttpMethod matches, such as
         * GET/POST/PUT etc. Multiple methods can be specified separated by
         * comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 httpMethodRestrict(
                String httpMethodRestrict) {
            doSetProperty("httpMethodRestrict", httpMethodRestrict);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 matchOnUriPrefix(
                boolean matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 matchOnUriPrefix(
                String matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 muteException(boolean muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 muteException(String muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * To use a custom buffer size on the javax.servlet.ServletResponse.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 responseBufferSize(
                Integer responseBufferSize) {
            doSetProperty("responseBufferSize", responseBufferSize);
            return this;
        }
        /**
         * To use a custom buffer size on the javax.servlet.ServletResponse.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 responseBufferSize(
                String responseBufferSize) {
            doSetProperty("responseBufferSize", responseBufferSize);
            return this;
        }
        /**
         * If the option is true, jetty server will send the date header to the
         * client which sends the request. NOTE please make sure there is no any
         * other camel-jetty endpoint is share the same port, otherwise this
         * option may not work as expected.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 sendDateHeader(boolean sendDateHeader) {
            doSetProperty("sendDateHeader", sendDateHeader);
            return this;
        }
        /**
         * If the option is true, jetty server will send the date header to the
         * client which sends the request. NOTE please make sure there is no any
         * other camel-jetty endpoint is share the same port, otherwise this
         * option may not work as expected.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 sendDateHeader(String sendDateHeader) {
            doSetProperty("sendDateHeader", sendDateHeader);
            return this;
        }
        /**
         * If the option is true, jetty will send the server header with the
         * jetty version information to the client which sends the request. NOTE
         * please make sure there is no any other camel-jetty endpoint is share
         * the same port, otherwise this option may not work as expected.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 sendServerVersion(
                boolean sendServerVersion) {
            doSetProperty("sendServerVersion", sendServerVersion);
            return this;
        }
        /**
         * If the option is true, jetty will send the server header with the
         * jetty version information to the client which sends the request. NOTE
         * please make sure there is no any other camel-jetty endpoint is share
         * the same port, otherwise this option may not work as expected.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 sendServerVersion(
                String sendServerVersion) {
            doSetProperty("sendServerVersion", sendServerVersion);
            return this;
        }
        /**
         * Specifies whether to enable the session manager on the server side of
         * Jetty.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 sessionSupport(boolean sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * Specifies whether to enable the session manager on the server side of
         * Jetty.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 sessionSupport(String sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Whether or not to use Jetty continuations for the Jetty Server.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 useContinuation(
                boolean useContinuation) {
            doSetProperty("useContinuation", useContinuation);
            return this;
        }
        /**
         * Whether or not to use Jetty continuations for the Jetty Server.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JettyHttpEndpointBuilder9 useContinuation(String useContinuation) {
            doSetProperty("useContinuation", useContinuation);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default JettyHttpEndpointBuilder9 sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default JettyHttpEndpointBuilder9 sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Jetty component.
     */
    public interface AdvancedJettyHttpEndpointBuilder9
            extends
                EndpointConsumerBuilder {
        default JettyHttpEndpointBuilder9 basic() {
            return (JettyHttpEndpointBuilder9) this;
        }
        /**
         * To use a custom HttpBinding to control the mapping between Camel
         * message and HttpClient.
         * 
         * The option is a:
         * <code>org.apache.camel.http.common.HttpBinding</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 httpBinding(Object httpBinding) {
            doSetProperty("httpBinding", httpBinding);
            return this;
        }
        /**
         * To use a custom HttpBinding to control the mapping between Camel
         * message and HttpClient.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.common.HttpBinding</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 httpBinding(String httpBinding) {
            doSetProperty("httpBinding", httpBinding);
            return this;
        }
        /**
         * Whether to eager check whether the HTTP requests has content if the
         * content-length header is 0 or not present. This can be turned on in
         * case HTTP clients do not send streamed data.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 eagerCheckContentAvailable(
                boolean eagerCheckContentAvailable) {
            doSetProperty("eagerCheckContentAvailable", eagerCheckContentAvailable);
            return this;
        }
        /**
         * Whether to eager check whether the HTTP requests has content if the
         * content-length header is 0 or not present. This can be turned on in
         * case HTTP clients do not send streamed data.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 eagerCheckContentAvailable(
                String eagerCheckContentAvailable) {
            doSetProperty("eagerCheckContentAvailable", eagerCheckContentAvailable);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Configuration of the filter init parameters. These parameters will be
         * applied to the filter list before starting the jetty server.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 filterInitParameters(
                Map<String, String> filterInitParameters) {
            doSetProperty("filterInitParameters", filterInitParameters);
            return this;
        }
        /**
         * Configuration of the filter init parameters. These parameters will be
         * applied to the filter list before starting the jetty server.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 filterInitParameters(
                String filterInitParameters) {
            doSetProperty("filterInitParameters", filterInitParameters);
            return this;
        }
        /**
         * Allows using a custom filters which is putted into a list and can be
         * find in the Registry. Multiple values can be separated by comma.
         * 
         * The option is a:
         * <code>java.util.List&lt;javax.servlet.Filter&gt;</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 filters(List<Object> filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * Allows using a custom filters which is putted into a list and can be
         * find in the Registry. Multiple values can be separated by comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;javax.servlet.Filter&gt;</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 filters(String filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * Specifies a comma-delimited set of Handler instances to lookup in
         * your Registry. These handlers are added to the Jetty servlet context
         * (for example, to add security). Important: You can not use different
         * handlers with different Jetty endpoints using the same port number.
         * The handlers is associated to the port number. If you need different
         * handlers, then use different port numbers.
         * 
         * The option is a:
         * <code>java.util.List&lt;org.eclipse.jetty.server.Handler&gt;</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 handlers(List<Object> handlers) {
            doSetProperty("handlers", handlers);
            return this;
        }
        /**
         * Specifies a comma-delimited set of Handler instances to lookup in
         * your Registry. These handlers are added to the Jetty servlet context
         * (for example, to add security). Important: You can not use different
         * handlers with different Jetty endpoints using the same port number.
         * The handlers is associated to the port number. If you need different
         * handlers, then use different port numbers.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;org.eclipse.jetty.server.Handler&gt;</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 handlers(String handlers) {
            doSetProperty("handlers", handlers);
            return this;
        }
        /**
         * Allows using a custom multipart filter. Note: setting
         * multipartFilterRef forces the value of enableMultipartFilter to true.
         * 
         * The option is a: <code>javax.servlet.Filter</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 multipartFilter(
                Object multipartFilter) {
            doSetProperty("multipartFilter", multipartFilter);
            return this;
        }
        /**
         * Allows using a custom multipart filter. Note: setting
         * multipartFilterRef forces the value of enableMultipartFilter to true.
         * 
         * The option will be converted to a <code>javax.servlet.Filter</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 multipartFilter(
                String multipartFilter) {
            doSetProperty("multipartFilter", multipartFilter);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 optionsEnabled(
                boolean optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 optionsEnabled(
                String optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Servlet consumer. By
         * default TRACE is turned off.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 traceEnabled(
                boolean traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Servlet consumer. By
         * default TRACE is turned off.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJettyHttpEndpointBuilder9 traceEnabled(
                String traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 mapHttpMessageBody(
                boolean mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 mapHttpMessageBody(
                String mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 mapHttpMessageFormUrlEncodedBody(
                boolean mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 mapHttpMessageFormUrlEncodedBody(
                String mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 mapHttpMessageHeaders(
                boolean mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 mapHttpMessageHeaders(
                String mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJettyHttpEndpointBuilder9 synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Jetty (camel-jetty)
     * To use Jetty as a HTTP server as consumer for Camel routes.
     * 
     * Category: http
     * Since: 1.2
     * Maven coordinates: org.apache.camel:camel-jetty
     * 
     * Syntax: <code>jetty:httpUri</code>
     * 
     * Path parameter: httpUri (required)
     * The url of the HTTP endpoint to call.
     */
    default JettyHttpEndpointBuilder9 jetty(String path) {
        class JettyHttpEndpointBuilder9Impl extends AbstractEndpointBuilder implements JettyHttpEndpointBuilder9, AdvancedJettyHttpEndpointBuilder9 {
            public JettyHttpEndpointBuilder9Impl(String path) {
                super("jetty", path);
            }
        }
        return new JettyHttpEndpointBuilder9Impl(path);
    }
}