/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The jcr component allows you to add/read nodes to/from a JCR compliant
 * content repository.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JcrEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the JCR component.
     */
    public interface JcrEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJcrEndpointConsumerBuilder advanced() {
            return (AdvancedJcrEndpointConsumerBuilder) this;
        }
        /**
         * When isDeep is true, events whose associated parent node is at
         * absPath or within its subgraph are received.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder deep(boolean deep) {
            doSetProperty("deep", deep);
            return this;
        }
        /**
         * When isDeep is true, events whose associated parent node is at
         * absPath or within its subgraph are received.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder deep(String deep) {
            doSetProperty("deep", deep);
            return this;
        }
        /**
         * eventTypes (a combination of one or more event types encoded as a bit
         * mask value such as javax.jcr.observation.Event.NODE_ADDED,
         * javax.jcr.observation.Event.NODE_REMOVED, etc.).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder eventTypes(int eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * eventTypes (a combination of one or more event types encoded as a bit
         * mask value such as javax.jcr.observation.Event.NODE_ADDED,
         * javax.jcr.observation.Event.NODE_REMOVED, etc.).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder eventTypes(String eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * When a comma separated nodeTypeName list string is set, only events
         * whose associated parent node has one of the node types (or a subtype
         * of one of the node types) in this list will be received.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder nodeTypeNames(String nodeTypeNames) {
            doSetProperty("nodeTypeNames", nodeTypeNames);
            return this;
        }
        /**
         * If noLocal is true, then events generated by the session through
         * which the listener was registered are ignored. Otherwise, they are
         * not ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder noLocal(boolean noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * If noLocal is true, then events generated by the session through
         * which the listener was registered are ignored. Otherwise, they are
         * not ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder noLocal(String noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Interval in milliseconds to wait before each session live checking
         * The default value is 60000 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder sessionLiveCheckInterval(
                long sessionLiveCheckInterval) {
            doSetProperty("sessionLiveCheckInterval", sessionLiveCheckInterval);
            return this;
        }
        /**
         * Interval in milliseconds to wait before each session live checking
         * The default value is 60000 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder sessionLiveCheckInterval(
                String sessionLiveCheckInterval) {
            doSetProperty("sessionLiveCheckInterval", sessionLiveCheckInterval);
            return this;
        }
        /**
         * Interval in milliseconds to wait before the first session live
         * checking. The default value is 3000 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder sessionLiveCheckIntervalOnStart(
                long sessionLiveCheckIntervalOnStart) {
            doSetProperty("sessionLiveCheckIntervalOnStart", sessionLiveCheckIntervalOnStart);
            return this;
        }
        /**
         * Interval in milliseconds to wait before the first session live
         * checking. The default value is 3000 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder sessionLiveCheckIntervalOnStart(
                String sessionLiveCheckIntervalOnStart) {
            doSetProperty("sessionLiveCheckIntervalOnStart", sessionLiveCheckIntervalOnStart);
            return this;
        }
        /**
         * Username for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * When a comma separated uuid list string is set, only events whose
         * associated parent node has one of the identifiers in the comma
         * separated uuid list will be received.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder uuids(String uuids) {
            doSetProperty("uuids", uuids);
            return this;
        }
        /**
         * The workspace to access. If it's not specified then the default one
         * will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointConsumerBuilder workspaceName(String workspaceName) {
            doSetProperty("workspaceName", workspaceName);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JcrEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JcrEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JCR component.
     */
    public interface AdvancedJcrEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default JcrEndpointConsumerBuilder basic() {
            return (JcrEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJcrEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJcrEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJcrEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJcrEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JCR component.
     */
    public interface JcrEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJcrEndpointProducerBuilder advanced() {
            return (AdvancedJcrEndpointProducerBuilder) this;
        }
        /**
         * When isDeep is true, events whose associated parent node is at
         * absPath or within its subgraph are received.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder deep(boolean deep) {
            doSetProperty("deep", deep);
            return this;
        }
        /**
         * When isDeep is true, events whose associated parent node is at
         * absPath or within its subgraph are received.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder deep(String deep) {
            doSetProperty("deep", deep);
            return this;
        }
        /**
         * eventTypes (a combination of one or more event types encoded as a bit
         * mask value such as javax.jcr.observation.Event.NODE_ADDED,
         * javax.jcr.observation.Event.NODE_REMOVED, etc.).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder eventTypes(int eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * eventTypes (a combination of one or more event types encoded as a bit
         * mask value such as javax.jcr.observation.Event.NODE_ADDED,
         * javax.jcr.observation.Event.NODE_REMOVED, etc.).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder eventTypes(String eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * When a comma separated nodeTypeName list string is set, only events
         * whose associated parent node has one of the node types (or a subtype
         * of one of the node types) in this list will be received.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder nodeTypeNames(String nodeTypeNames) {
            doSetProperty("nodeTypeNames", nodeTypeNames);
            return this;
        }
        /**
         * If noLocal is true, then events generated by the session through
         * which the listener was registered are ignored. Otherwise, they are
         * not ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder noLocal(boolean noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * If noLocal is true, then events generated by the session through
         * which the listener was registered are ignored. Otherwise, they are
         * not ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder noLocal(String noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Interval in milliseconds to wait before each session live checking
         * The default value is 60000 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder sessionLiveCheckInterval(
                long sessionLiveCheckInterval) {
            doSetProperty("sessionLiveCheckInterval", sessionLiveCheckInterval);
            return this;
        }
        /**
         * Interval in milliseconds to wait before each session live checking
         * The default value is 60000 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder sessionLiveCheckInterval(
                String sessionLiveCheckInterval) {
            doSetProperty("sessionLiveCheckInterval", sessionLiveCheckInterval);
            return this;
        }
        /**
         * Interval in milliseconds to wait before the first session live
         * checking. The default value is 3000 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder sessionLiveCheckIntervalOnStart(
                long sessionLiveCheckIntervalOnStart) {
            doSetProperty("sessionLiveCheckIntervalOnStart", sessionLiveCheckIntervalOnStart);
            return this;
        }
        /**
         * Interval in milliseconds to wait before the first session live
         * checking. The default value is 3000 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder sessionLiveCheckIntervalOnStart(
                String sessionLiveCheckIntervalOnStart) {
            doSetProperty("sessionLiveCheckIntervalOnStart", sessionLiveCheckIntervalOnStart);
            return this;
        }
        /**
         * Username for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * When a comma separated uuid list string is set, only events whose
         * associated parent node has one of the identifiers in the comma
         * separated uuid list will be received.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder uuids(String uuids) {
            doSetProperty("uuids", uuids);
            return this;
        }
        /**
         * The workspace to access. If it's not specified then the default one
         * will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointProducerBuilder workspaceName(String workspaceName) {
            doSetProperty("workspaceName", workspaceName);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JcrEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JcrEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JCR component.
     */
    public interface AdvancedJcrEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default JcrEndpointProducerBuilder basic() {
            return (JcrEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the JCR component.
     */
    public interface JcrEndpointBuilder
            extends
                JcrEndpointConsumerBuilder, JcrEndpointProducerBuilder {
        default AdvancedJcrEndpointBuilder advanced() {
            return (AdvancedJcrEndpointBuilder) this;
        }
        /**
         * When isDeep is true, events whose associated parent node is at
         * absPath or within its subgraph are received.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder deep(boolean deep) {
            doSetProperty("deep", deep);
            return this;
        }
        /**
         * When isDeep is true, events whose associated parent node is at
         * absPath or within its subgraph are received.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder deep(String deep) {
            doSetProperty("deep", deep);
            return this;
        }
        /**
         * eventTypes (a combination of one or more event types encoded as a bit
         * mask value such as javax.jcr.observation.Event.NODE_ADDED,
         * javax.jcr.observation.Event.NODE_REMOVED, etc.).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder eventTypes(int eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * eventTypes (a combination of one or more event types encoded as a bit
         * mask value such as javax.jcr.observation.Event.NODE_ADDED,
         * javax.jcr.observation.Event.NODE_REMOVED, etc.).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder eventTypes(String eventTypes) {
            doSetProperty("eventTypes", eventTypes);
            return this;
        }
        /**
         * When a comma separated nodeTypeName list string is set, only events
         * whose associated parent node has one of the node types (or a subtype
         * of one of the node types) in this list will be received.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder nodeTypeNames(String nodeTypeNames) {
            doSetProperty("nodeTypeNames", nodeTypeNames);
            return this;
        }
        /**
         * If noLocal is true, then events generated by the session through
         * which the listener was registered are ignored. Otherwise, they are
         * not ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder noLocal(boolean noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * If noLocal is true, then events generated by the session through
         * which the listener was registered are ignored. Otherwise, they are
         * not ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder noLocal(String noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * Password for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Interval in milliseconds to wait before each session live checking
         * The default value is 60000 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder sessionLiveCheckInterval(
                long sessionLiveCheckInterval) {
            doSetProperty("sessionLiveCheckInterval", sessionLiveCheckInterval);
            return this;
        }
        /**
         * Interval in milliseconds to wait before each session live checking
         * The default value is 60000 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder sessionLiveCheckInterval(
                String sessionLiveCheckInterval) {
            doSetProperty("sessionLiveCheckInterval", sessionLiveCheckInterval);
            return this;
        }
        /**
         * Interval in milliseconds to wait before the first session live
         * checking. The default value is 3000 ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder sessionLiveCheckIntervalOnStart(
                long sessionLiveCheckIntervalOnStart) {
            doSetProperty("sessionLiveCheckIntervalOnStart", sessionLiveCheckIntervalOnStart);
            return this;
        }
        /**
         * Interval in milliseconds to wait before the first session live
         * checking. The default value is 3000 ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder sessionLiveCheckIntervalOnStart(
                String sessionLiveCheckIntervalOnStart) {
            doSetProperty("sessionLiveCheckIntervalOnStart", sessionLiveCheckIntervalOnStart);
            return this;
        }
        /**
         * Username for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * When a comma separated uuid list string is set, only events whose
         * associated parent node has one of the identifiers in the comma
         * separated uuid list will be received.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder uuids(String uuids) {
            doSetProperty("uuids", uuids);
            return this;
        }
        /**
         * The workspace to access. If it's not specified then the default one
         * will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JcrEndpointBuilder workspaceName(String workspaceName) {
            doSetProperty("workspaceName", workspaceName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JCR component.
     */
    public interface AdvancedJcrEndpointBuilder
            extends
                AdvancedJcrEndpointConsumerBuilder, AdvancedJcrEndpointProducerBuilder {
        default JcrEndpointBuilder basic() {
            return (JcrEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJcrEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * JCR (camel-jcr)
     * The jcr component allows you to add/read nodes to/from a JCR compliant
     * content repository.
     * 
     * Category: cms,database
     * Since: 1.3
     * Maven coordinates: org.apache.camel:camel-jcr
     * 
     * Syntax: <code>jcr:host/base</code>
     * 
     * Path parameter: host (required)
     * Name of the javax.jcr.Repository to lookup from the Camel registry to be
     * used.
     * 
     * Path parameter: base
     * Get the base node when accessing the repository
     */
    default JcrEndpointBuilder jcr(String path) {
        class JcrEndpointBuilderImpl extends AbstractEndpointBuilder implements JcrEndpointBuilder, AdvancedJcrEndpointBuilder {
            public JcrEndpointBuilderImpl(String path) {
                super("jcr", path);
            }
        }
        return new JcrEndpointBuilderImpl(path);
    }
}