/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * The elsql component is an extension to the existing SQL Component that uses
 * ElSql to define the SQL queries.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ElsqlEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the ElSQL component.
     */
    public interface ElsqlEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedElsqlEndpointConsumerBuilder advanced() {
            return (AdvancedElsqlEndpointConsumerBuilder) this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder allowNamedParameters(
                boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder allowNamedParameters(
                String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option is a:
         * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder databaseVendor(
                ElSqlDatabaseVendor databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder databaseVendor(
                String databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database.
         * 
         * The option is a: <code>javax.sql.DataSource</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder dataSource(Object dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database.
         * 
         * The option will be converted to a <code>javax.sql.DataSource</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the reference to a DataSource to lookup from the registry, to
         * use for communicating with the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default ElsqlEndpointConsumerBuilder dataSourceRef(String dataSourceRef) {
            doSetProperty("dataSourceRef", dataSourceRef);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder outputType(SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointConsumerBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * Sets whether to break batch if onConsume failed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder breakBatchOnConsumeFail(
                boolean breakBatchOnConsumeFail) {
            doSetProperty("breakBatchOnConsumeFail", breakBatchOnConsumeFail);
            return this;
        }
        /**
         * Sets whether to break batch if onConsume failed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder breakBatchOnConsumeFail(
                String breakBatchOnConsumeFail) {
            doSetProperty("breakBatchOnConsumeFail", breakBatchOnConsumeFail);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets an expected update count to validate when using onConsume.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder expectedUpdateCount(
                int expectedUpdateCount) {
            doSetProperty("expectedUpdateCount", expectedUpdateCount);
            return this;
        }
        /**
         * Sets an expected update count to validate when using onConsume.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder expectedUpdateCount(
                String expectedUpdateCount) {
            doSetProperty("expectedUpdateCount", expectedUpdateCount);
            return this;
        }
        /**
         * Sets the maximum number of messages to poll.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Sets the maximum number of messages to poll.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * After processing each row then this query can be executed, if the
         * Exchange was processed successfully, for example to mark the row as
         * processed. The query can have parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder onConsume(String onConsume) {
            doSetProperty("onConsume", onConsume);
            return this;
        }
        /**
         * After processing the entire batch, this query can be executed to bulk
         * update rows etc. The query cannot have parameters.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder onConsumeBatchComplete(
                String onConsumeBatchComplete) {
            doSetProperty("onConsumeBatchComplete", onConsumeBatchComplete);
            return this;
        }
        /**
         * After processing each row then this query can be executed, if the
         * Exchange failed, for example to mark the row as failed. The query can
         * have parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder onConsumeFailed(
                String onConsumeFailed) {
            doSetProperty("onConsumeFailed", onConsumeFailed);
            return this;
        }
        /**
         * Sets whether empty resultset should be allowed to be sent to the next
         * hop. Defaults to false. So the empty resultset will be filtered out.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder routeEmptyResultSet(
                boolean routeEmptyResultSet) {
            doSetProperty("routeEmptyResultSet", routeEmptyResultSet);
            return this;
        }
        /**
         * Sets whether empty resultset should be allowed to be sent to the next
         * hop. Defaults to false. So the empty resultset will be filtered out.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder routeEmptyResultSet(
                String routeEmptyResultSet) {
            doSetProperty("routeEmptyResultSet", routeEmptyResultSet);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Enables or disables transaction. If enabled then if processing an
         * exchange failed then the consumerbreak out processing any further
         * exchanges to cause a rollback eager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Enables or disables transaction. If enabled then if processing an
         * exchange failed then the consumerbreak out processing any further
         * exchanges to cause a rollback eager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Sets how resultset should be delivered to route. Indicates delivery
         * as either a list or individual object. defaults to true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder useIterator(boolean useIterator) {
            doSetProperty("useIterator", useIterator);
            return this;
        }
        /**
         * Sets how resultset should be delivered to route. Indicates delivery
         * as either a list or individual object. defaults to true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ElsqlEndpointConsumerBuilder useIterator(String useIterator) {
            doSetProperty("useIterator", useIterator);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default ElsqlEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the ElSQL component.
     */
    public interface AdvancedElsqlEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ElsqlEndpointConsumerBuilder basic() {
            return (ElsqlEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlProcessingStrategy to execute
         * queries when the consumer has processed the rows/batch.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlProcessingStrategy</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder processingStrategy(
                Object processingStrategy) {
            doSetProperty("processingStrategy", processingStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlProcessingStrategy to execute
         * queries when the consumer has processed the rows/batch.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlProcessingStrategy</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedElsqlEndpointConsumerBuilder processingStrategy(
                String processingStrategy) {
            doSetProperty("processingStrategy", processingStrategy);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder alwaysPopulateStatement(
                boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder alwaysPopulateStatement(
                String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option is a: <code>com.opengamma.elsql.ElSqlConfig</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder elSqlConfig(
                Object elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option will be converted to a
         * <code>com.opengamma.elsql.ElSqlConfig</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder elSqlConfig(
                String elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder parametersCount(
                int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder parametersCount(
                String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder placeholder(
                String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder prepareStatementStrategy(
                Object prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder prepareStatementStrategy(
                String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder templateOptions(
                Map<String, Object> templateOptions) {
            doSetProperty("templateOptions", templateOptions);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder templateOptions(
                String templateOptions) {
            doSetProperty("templateOptions", templateOptions);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder usePlaceholder(
                boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointConsumerBuilder usePlaceholder(
                String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the ElSQL component.
     */
    public interface ElsqlEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedElsqlEndpointProducerBuilder advanced() {
            return (AdvancedElsqlEndpointProducerBuilder) this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder allowNamedParameters(
                boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder allowNamedParameters(
                String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option is a:
         * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder databaseVendor(
                ElSqlDatabaseVendor databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder databaseVendor(
                String databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database.
         * 
         * The option is a: <code>javax.sql.DataSource</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder dataSource(Object dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database.
         * 
         * The option will be converted to a <code>javax.sql.DataSource</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the reference to a DataSource to lookup from the registry, to
         * use for communicating with the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default ElsqlEndpointProducerBuilder dataSourceRef(String dataSourceRef) {
            doSetProperty("dataSourceRef", dataSourceRef);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder outputType(SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointProducerBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * Enables or disables batch mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder batch(boolean batch) {
            doSetProperty("batch", batch);
            return this;
        }
        /**
         * Enables or disables batch mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder batch(String batch) {
            doSetProperty("batch", batch);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If set, will ignore the results of the SQL query and use the existing
         * IN message as the OUT message for the continuation of processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder noop(boolean noop) {
            doSetProperty("noop", noop);
            return this;
        }
        /**
         * If set, will ignore the results of the SQL query and use the existing
         * IN message as the OUT message for the continuation of processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder noop(String noop) {
            doSetProperty("noop", noop);
            return this;
        }
        /**
         * Whether to use the message body as the SQL and then headers for
         * parameters. If this option is enabled then the SQL in the uri is not
         * used.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder useMessageBodyForSql(
                boolean useMessageBodyForSql) {
            doSetProperty("useMessageBodyForSql", useMessageBodyForSql);
            return this;
        }
        /**
         * Whether to use the message body as the SQL and then headers for
         * parameters. If this option is enabled then the SQL in the uri is not
         * used.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ElsqlEndpointProducerBuilder useMessageBodyForSql(
                String useMessageBodyForSql) {
            doSetProperty("useMessageBodyForSql", useMessageBodyForSql);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the ElSQL component.
     */
    public interface AdvancedElsqlEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ElsqlEndpointProducerBuilder basic() {
            return (ElsqlEndpointProducerBuilder) this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder alwaysPopulateStatement(
                boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder alwaysPopulateStatement(
                String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option is a: <code>com.opengamma.elsql.ElSqlConfig</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder elSqlConfig(
                Object elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option will be converted to a
         * <code>com.opengamma.elsql.ElSqlConfig</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder elSqlConfig(
                String elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder parametersCount(
                int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder parametersCount(
                String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder placeholder(
                String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder prepareStatementStrategy(
                Object prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder prepareStatementStrategy(
                String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder templateOptions(
                Map<String, Object> templateOptions) {
            doSetProperty("templateOptions", templateOptions);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder templateOptions(
                String templateOptions) {
            doSetProperty("templateOptions", templateOptions);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder usePlaceholder(
                boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointProducerBuilder usePlaceholder(
                String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Builder for endpoint for the ElSQL component.
     */
    public interface ElsqlEndpointBuilder
            extends
                ElsqlEndpointConsumerBuilder, ElsqlEndpointProducerBuilder {
        default AdvancedElsqlEndpointBuilder advanced() {
            return (AdvancedElsqlEndpointBuilder) this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder allowNamedParameters(
                boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder allowNamedParameters(
                String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option is a:
         * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder databaseVendor(
                ElSqlDatabaseVendor databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder databaseVendor(String databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database.
         * 
         * The option is a: <code>javax.sql.DataSource</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder dataSource(Object dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database.
         * 
         * The option will be converted to a <code>javax.sql.DataSource</code>
         * type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the reference to a DataSource to lookup from the registry, to
         * use for communicating with the database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default ElsqlEndpointBuilder dataSourceRef(String dataSourceRef) {
            doSetProperty("dataSourceRef", dataSourceRef);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder outputType(SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default ElsqlEndpointBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the ElSQL component.
     */
    public interface AdvancedElsqlEndpointBuilder
            extends
                AdvancedElsqlEndpointConsumerBuilder, AdvancedElsqlEndpointProducerBuilder {
        default ElsqlEndpointBuilder basic() {
            return (ElsqlEndpointBuilder) this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder alwaysPopulateStatement(
                boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder alwaysPopulateStatement(
                String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option is a: <code>com.opengamma.elsql.ElSqlConfig</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder elSqlConfig(Object elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option will be converted to a
         * <code>com.opengamma.elsql.ElSqlConfig</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder elSqlConfig(String elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder parametersCount(int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder parametersCount(
                String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder placeholder(String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder prepareStatementStrategy(
                Object prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder prepareStatementStrategy(
                String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder templateOptions(
                Map<String, Object> templateOptions) {
            doSetProperty("templateOptions", templateOptions);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder templateOptions(
                String templateOptions) {
            doSetProperty("templateOptions", templateOptions);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder usePlaceholder(
                boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedElsqlEndpointBuilder usePlaceholder(
                String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code> enum.
     */
    enum ElSqlDatabaseVendor {
        Default,
        Postgres,
        HSql,
        MySql,
        Oracle,
        SqlServer2008,
        Veritca;
    }

    /**
     * Proxy enum for <code>org.apache.camel.component.sql.SqlOutputType</code>
     * enum.
     */
    enum SqlOutputType {
        SelectOne,
        SelectList,
        StreamList;
    }
    /**
     * ElSQL (camel-elsql)
     * The elsql component is an extension to the existing SQL Component that
     * uses ElSql to define the SQL queries.
     * 
     * Category: database,sql
     * Since: 2.16
     * Maven coordinates: org.apache.camel:camel-elsql
     * 
     * Syntax: <code>elsql:elsqlName:resourceUri</code>
     * 
     * Path parameter: elsqlName (required)
     * The name of the elsql to use (is NAMED in the elsql file)
     * 
     * Path parameter: resourceUri
     * The resource file which contains the elsql SQL statements to use. You can
     * specify multiple resources separated by comma. The resources are loaded
     * on the classpath by default, you can prefix with file: to load from file
     * system. Notice you can set this option on the component and then you do
     * not have to configure this on the endpoint.
     */
    default ElsqlEndpointBuilder elsql(String path) {
        class ElsqlEndpointBuilderImpl extends AbstractEndpointBuilder implements ElsqlEndpointBuilder, AdvancedElsqlEndpointBuilder {
            public ElsqlEndpointBuilderImpl(String path) {
                super("elsql", path);
            }
        }
        return new ElsqlEndpointBuilderImpl(path);
    }
}