/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Represents a Debezium MySQL endpoint which is used to capture changes in
 * MySQL database so that that applications can see those changes and respond to
 * them.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DebeziumMySqlEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Debezium MySQL Connector component.
     */
    public interface DebeziumMySqlEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDebeziumMySqlEndpointBuilder advanced() {
            return (AdvancedDebeziumMySqlEndpointBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder internalKeyConverter(
                String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder internalValueConverter(
                String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetCommitPolicy(
                String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetCommitTimeoutMs(
                long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetCommitTimeoutMs(
                String offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetFlushIntervalMs(
                long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetFlushIntervalMs(
                String offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetStorage(String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetStorageFileName(
                String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetStoragePartitions(
                int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetStoragePartitions(
                String offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetStorageReplicationFactor(
                int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetStorageReplicationFactor(
                String offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default DebeziumMySqlEndpointBuilder offsetStorageTopic(
                String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * Specify how BIGINT UNSIGNED columns should be represented in change
         * events, including:'precise' uses java.math.BigDecimal to represent
         * values, which are encoded in the change events using a binary
         * representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'long' (the default)
         * represents values using Java's 'long', which may not offer the
         * precision but will be far easier to use in consumers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder bigintUnsignedHandlingMode(
                String bigintUnsignedHandlingMode) {
            doSetProperty("bigintUnsignedHandlingMode", bigintUnsignedHandlingMode);
            return this;
        }
        /**
         * The size of a look-ahead buffer used by the binlog reader to decide
         * whether the transaction in progress is going to be committed or
         * rolled back. Use 0 to disable look-ahead buffering. Defaults to 0
         * (i.e. buffering is disabled).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder binlogBufferSize(
                int binlogBufferSize) {
            doSetProperty("binlogBufferSize", binlogBufferSize);
            return this;
        }
        /**
         * The size of a look-ahead buffer used by the binlog reader to decide
         * whether the transaction in progress is going to be committed or
         * rolled back. Use 0 to disable look-ahead buffering. Defaults to 0
         * (i.e. buffering is disabled).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder binlogBufferSize(
                String binlogBufferSize) {
            doSetProperty("binlogBufferSize", binlogBufferSize);
            return this;
        }
        /**
         * Description is not available here, please check Debezium website for
         * corresponding key 'column.blacklist' description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder columnBlacklist(
                String columnBlacklist) {
            doSetProperty("columnBlacklist", columnBlacklist);
            return this;
        }
        /**
         * Whether a separate thread should be used to ensure the connection is
         * kept alive.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder connectKeepAlive(
                boolean connectKeepAlive) {
            doSetProperty("connectKeepAlive", connectKeepAlive);
            return this;
        }
        /**
         * Whether a separate thread should be used to ensure the connection is
         * kept alive.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder connectKeepAlive(
                String connectKeepAlive) {
            doSetProperty("connectKeepAlive", connectKeepAlive);
            return this;
        }
        /**
         * Interval in milliseconds to wait for connection checking if keep
         * alive thread is used.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder connectKeepAliveIntervalMs(
                long connectKeepAliveIntervalMs) {
            doSetProperty("connectKeepAliveIntervalMs", connectKeepAliveIntervalMs);
            return this;
        }
        /**
         * Interval in milliseconds to wait for connection checking if keep
         * alive thread is used.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder connectKeepAliveIntervalMs(
                String connectKeepAliveIntervalMs) {
            doSetProperty("connectKeepAliveIntervalMs", connectKeepAliveIntervalMs);
            return this;
        }
        /**
         * Maximum time in milliseconds to wait after trying to connect to the
         * database before timing out.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder connectTimeoutMs(
                int connectTimeoutMs) {
            doSetProperty("connectTimeoutMs", connectTimeoutMs);
            return this;
        }
        /**
         * Maximum time in milliseconds to wait after trying to connect to the
         * database before timing out.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder connectTimeoutMs(
                String connectTimeoutMs) {
            doSetProperty("connectTimeoutMs", connectTimeoutMs);
            return this;
        }
        /**
         * Description is not available here, please check Debezium website for
         * corresponding key 'database.blacklist' description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseBlacklist(
                String databaseBlacklist) {
            doSetProperty("databaseBlacklist", databaseBlacklist);
            return this;
        }
        /**
         * The name of the DatabaseHistory class that should be used to store
         * and recover database schema changes. The configuration properties for
         * the history are prefixed with the 'database.history.' string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistory(
                String databaseHistory) {
            doSetProperty("databaseHistory", databaseHistory);
            return this;
        }
        /**
         * The path to the file that will be used to record the database
         * history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryFileFilename(
                String databaseHistoryFileFilename) {
            doSetProperty("databaseHistoryFileFilename", databaseHistoryFileFilename);
            return this;
        }
        /**
         * A list of host/port pairs that the connector will use for
         * establishing the initial connection to the Kafka cluster for
         * retrieving database schema history previously stored by the
         * connector. This should point to the same Kafka cluster used by the
         * Kafka Connect process.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryKafkaBootstrapServers(
                String databaseHistoryKafkaBootstrapServers) {
            doSetProperty("databaseHistoryKafkaBootstrapServers", databaseHistoryKafkaBootstrapServers);
            return this;
        }
        /**
         * The number of attempts in a row that no data are returned from Kafka
         * before recover completes. The maximum amount of time to wait after
         * receiving no data is (recovery.attempts) x
         * (recovery.poll.interval.ms).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryKafkaRecoveryAttempts(
                int databaseHistoryKafkaRecoveryAttempts) {
            doSetProperty("databaseHistoryKafkaRecoveryAttempts", databaseHistoryKafkaRecoveryAttempts);
            return this;
        }
        /**
         * The number of attempts in a row that no data are returned from Kafka
         * before recover completes. The maximum amount of time to wait after
         * receiving no data is (recovery.attempts) x
         * (recovery.poll.interval.ms).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryKafkaRecoveryAttempts(
                String databaseHistoryKafkaRecoveryAttempts) {
            doSetProperty("databaseHistoryKafkaRecoveryAttempts", databaseHistoryKafkaRecoveryAttempts);
            return this;
        }
        /**
         * The number of milliseconds to wait while polling for persisted data
         * during recovery.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryKafkaRecoveryPollIntervalMs(
                int databaseHistoryKafkaRecoveryPollIntervalMs) {
            doSetProperty("databaseHistoryKafkaRecoveryPollIntervalMs", databaseHistoryKafkaRecoveryPollIntervalMs);
            return this;
        }
        /**
         * The number of milliseconds to wait while polling for persisted data
         * during recovery.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryKafkaRecoveryPollIntervalMs(
                String databaseHistoryKafkaRecoveryPollIntervalMs) {
            doSetProperty("databaseHistoryKafkaRecoveryPollIntervalMs", databaseHistoryKafkaRecoveryPollIntervalMs);
            return this;
        }
        /**
         * The name of the topic for the database schema history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryKafkaTopic(
                String databaseHistoryKafkaTopic) {
            doSetProperty("databaseHistoryKafkaTopic", databaseHistoryKafkaTopic);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistorySkipUnparseableDdl(
                boolean databaseHistorySkipUnparseableDdl) {
            doSetProperty("databaseHistorySkipUnparseableDdl", databaseHistorySkipUnparseableDdl);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistorySkipUnparseableDdl(
                String databaseHistorySkipUnparseableDdl) {
            doSetProperty("databaseHistorySkipUnparseableDdl", databaseHistorySkipUnparseableDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database history.By default
         * (false) Debezium will store all incoming DDL statements. If set to
         * truethen only DDL that manipulates a monitored table will be stored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryStoreOnlyMonitoredTablesDdl(
                boolean databaseHistoryStoreOnlyMonitoredTablesDdl) {
            doSetProperty("databaseHistoryStoreOnlyMonitoredTablesDdl", databaseHistoryStoreOnlyMonitoredTablesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database history.By default
         * (false) Debezium will store all incoming DDL statements. If set to
         * truethen only DDL that manipulates a monitored table will be stored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHistoryStoreOnlyMonitoredTablesDdl(
                String databaseHistoryStoreOnlyMonitoredTablesDdl) {
            doSetProperty("databaseHistoryStoreOnlyMonitoredTablesDdl", databaseHistoryStoreOnlyMonitoredTablesDdl);
            return this;
        }
        /**
         * Resolvable hostname or IP address of the MySQL database server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseHostname(
                String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
        /**
         * A semicolon separated list of SQL statements to be executed when a
         * JDBC connection (not binlog reading connection) to the database is
         * established. Note that the connector may establish JDBC connections
         * at its own discretion, so this should typically be used for
         * configuration of session parameters only,but not for executing DML
         * statements. Use doubled semicolon (';;') to use a semicolon as a
         * character and not as a delimiter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseInitialStatements(
                String databaseInitialStatements) {
            doSetProperty("databaseInitialStatements", databaseInitialStatements);
            return this;
        }
        /**
         * JDBC Driver class name used to connect to the MySQL database server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseJdbcDriver(
                String databaseJdbcDriver) {
            doSetProperty("databaseJdbcDriver", databaseJdbcDriver);
            return this;
        }
        /**
         * Password of the MySQL database user to be used when connecting to the
         * database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databasePassword(
                String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
        /**
         * Port of the MySQL database server.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Port of the MySQL database server.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databasePort(String databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * A numeric ID of this database client, which must be unique across all
         * currently-running database processes in the cluster. This connector
         * joins the MySQL database cluster as another server (with this unique
         * ID) so it can read the binlog. By default, a random number is
         * generated between 5400 and 6400.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseServerId(
                long databaseServerId) {
            doSetProperty("databaseServerId", databaseServerId);
            return this;
        }
        /**
         * A numeric ID of this database client, which must be unique across all
         * currently-running database processes in the cluster. This connector
         * joins the MySQL database cluster as another server (with this unique
         * ID) so it can read the binlog. By default, a random number is
         * generated between 5400 and 6400.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseServerId(
                String databaseServerId) {
            doSetProperty("databaseServerId", databaseServerId);
            return this;
        }
        /**
         * Only relevant if parallel snapshotting is configured. During parallel
         * snapshotting, multiple (4) connections open to the database client,
         * and they each need their own unique connection ID. This offset is
         * used to generate those IDs from the base configured cluster ID.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseServerIdOffset(
                long databaseServerIdOffset) {
            doSetProperty("databaseServerIdOffset", databaseServerIdOffset);
            return this;
        }
        /**
         * Only relevant if parallel snapshotting is configured. During parallel
         * snapshotting, multiple (4) connections open to the database client,
         * and they each need their own unique connection ID. This offset is
         * used to generate those IDs from the base configured cluster ID.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseServerIdOffset(
                String databaseServerIdOffset) {
            doSetProperty("databaseServerIdOffset", databaseServerIdOffset);
            return this;
        }
        /**
         * Unique name that identifies the database server and all recorded
         * offsets, and that is used as a prefix for all schemas and topics.
         * Each distinct installation should have a separate namespace and be
         * monitored by at most one Debezium connector.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseServerName(
                String databaseServerName) {
            doSetProperty("databaseServerName", databaseServerName);
            return this;
        }
        /**
         * Location of the Java keystore file containing an application
         * process's own certificate and private key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseSslKeystore(
                String databaseSslKeystore) {
            doSetProperty("databaseSslKeystore", databaseSslKeystore);
            return this;
        }
        /**
         * Password to access the private key from the keystore file specified
         * by 'ssl.keystore' configuration property or the
         * 'javax.net.ssl.keyStore' system or JVM property. This password is
         * used to unlock the keystore file (store password), and to decrypt the
         * private key stored in the keystore (key password).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseSslKeystorePassword(
                String databaseSslKeystorePassword) {
            doSetProperty("databaseSslKeystorePassword", databaseSslKeystorePassword);
            return this;
        }
        /**
         * Whether to use an encrypted connection to MySQL. Options
         * include'disabled' (the default) to use an unencrypted connection;
         * 'preferred' to establish a secure (encrypted) connection if the
         * server supports secure connections, but fall back to an unencrypted
         * connection otherwise; 'required' to use a secure (encrypted)
         * connection, and fail if one cannot be established; 'verify_ca' like
         * 'required' but additionally verify the server TLS certificate against
         * the configured Certificate Authority (CA) certificates, or fail if no
         * valid matching CA certificates are found; or'verify_identity' like
         * 'verify_ca' but additionally verify that the server certificate
         * matches the host to which the connection is attempted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseSslMode(
                String databaseSslMode) {
            doSetProperty("databaseSslMode", databaseSslMode);
            return this;
        }
        /**
         * Location of the Java truststore file containing the collection of CA
         * certificates trusted by this application process (trust store).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseSslTruststore(
                String databaseSslTruststore) {
            doSetProperty("databaseSslTruststore", databaseSslTruststore);
            return this;
        }
        /**
         * Password to unlock the keystore file (store password) specified by
         * 'ssl.trustore' configuration property or the
         * 'javax.net.ssl.trustStore' system or JVM property.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseSslTruststorePassword(
                String databaseSslTruststorePassword) {
            doSetProperty("databaseSslTruststorePassword", databaseSslTruststorePassword);
            return this;
        }
        /**
         * Name of the MySQL database user to be used when connecting to the
         * database.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseUser(String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
        /**
         * The databases for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder databaseWhitelist(
                String databaseWhitelist) {
            doSetProperty("databaseWhitelist", databaseWhitelist);
            return this;
        }
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including:'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder decimalHandlingMode(
                String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
        /**
         * MySQL allows user to insert year value as either 2-digit or 4-digit.
         * In case of two digit the value is automatically mapped into 1970 -
         * 2069.false - delegates the implicit conversion to the databasetrue -
         * (the default) Debezium makes the conversion.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder enableTimeAdjuster(
                boolean enableTimeAdjuster) {
            doSetProperty("enableTimeAdjuster", enableTimeAdjuster);
            return this;
        }
        /**
         * MySQL allows user to insert year value as either 2-digit or 4-digit.
         * In case of two digit the value is automatically mapped into 1970 -
         * 2069.false - delegates the implicit conversion to the databasetrue -
         * (the default) Debezium makes the conversion.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder enableTimeAdjuster(
                String enableTimeAdjuster) {
            doSetProperty("enableTimeAdjuster", enableTimeAdjuster);
            return this;
        }
        /**
         * Specify how failures during deserialization of binlog events (i.e.
         * when encountering a corrupted event) should be handled,
         * including:'fail' (the default) an exception indicating the
         * problematic event and its binlog position is raised, causing the
         * connector to be stopped; 'warn' the problematic event and its binlog
         * position will be logged and the event will be skipped;'ignore' the
         * problematic event will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder eventDeserializationFailureHandlingMode(
                String eventDeserializationFailureHandlingMode) {
            doSetProperty("eventDeserializationFailureHandlingMode", eventDeserializationFailureHandlingMode);
            return this;
        }
        /**
         * If set to 'latest', when connector sees new GTID, it will start
         * consuming gtid channel from the server latest executed gtid position.
         * If 'earliest' connector starts reading channel from first available
         * (not purged) gtid position on the server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder gtidNewChannelPosition(
                String gtidNewChannelPosition) {
            doSetProperty("gtidNewChannelPosition", gtidNewChannelPosition);
            return this;
        }
        /**
         * The source UUIDs used to exclude GTID ranges when determine the
         * starting position in the MySQL server's binlog.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder gtidSourceExcludes(
                String gtidSourceExcludes) {
            doSetProperty("gtidSourceExcludes", gtidSourceExcludes);
            return this;
        }
        /**
         * If set to true, we will only produce DML events into Kafka for
         * transactions that were written on mysql servers with UUIDs matching
         * the filters defined by the gtid.source.includes or
         * gtid.source.excludes configuration options, if they are specified.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder gtidSourceFilterDmlEvents(
                boolean gtidSourceFilterDmlEvents) {
            doSetProperty("gtidSourceFilterDmlEvents", gtidSourceFilterDmlEvents);
            return this;
        }
        /**
         * If set to true, we will only produce DML events into Kafka for
         * transactions that were written on mysql servers with UUIDs matching
         * the filters defined by the gtid.source.includes or
         * gtid.source.excludes configuration options, if they are specified.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder gtidSourceFilterDmlEvents(
                String gtidSourceFilterDmlEvents) {
            doSetProperty("gtidSourceFilterDmlEvents", gtidSourceFilterDmlEvents);
            return this;
        }
        /**
         * The source UUIDs used to include GTID ranges when determine the
         * starting position in the MySQL server's binlog.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder gtidSourceIncludes(
                String gtidSourceIncludes) {
            doSetProperty("gtidSourceIncludes", gtidSourceIncludes);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder heartbeatIntervalMs(
                int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder heartbeatIntervalMs(
                String heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder heartbeatTopicsPrefix(
                String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Whether the connector should include the original SQL query that
         * generated the change event. Note: This option requires MySQL be
         * configured with the binlog_rows_query_log_events option set to ON.
         * Query will not be present for events generated from snapshot.
         * WARNING: Enabling this option may expose tables or fields explicitly
         * blacklisted or masked by including the original SQL statement in the
         * change event. For this reason the default value is 'false'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder includeQuery(boolean includeQuery) {
            doSetProperty("includeQuery", includeQuery);
            return this;
        }
        /**
         * Whether the connector should include the original SQL query that
         * generated the change event. Note: This option requires MySQL be
         * configured with the binlog_rows_query_log_events option set to ON.
         * Query will not be present for events generated from snapshot.
         * WARNING: Enabling this option may expose tables or fields explicitly
         * blacklisted or masked by including the original SQL statement in the
         * change event. For this reason the default value is 'false'.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder includeQuery(String includeQuery) {
            doSetProperty("includeQuery", includeQuery);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value includes the DDL statement(s).The default is
         * 'true'. This is independent of how the connector internally records
         * database history.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder includeSchemaChanges(
                boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value includes the DDL statement(s).The default is
         * 'true'. This is independent of how the connector internally records
         * database history.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder includeSchemaChanges(
                String includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Specify how binlog events that belong to a table missing from
         * internal schema representation (i.e. internal representation is not
         * consistent with database) should be handled, including:'fail' (the
         * default) an exception indicating the problematic event and its binlog
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its binlog position will be logged and the
         * event will be skipped;'ignore' the problematic event will be skipped.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder inconsistentSchemaHandlingMode(
                String inconsistentSchemaHandlingMode) {
            doSetProperty("inconsistentSchemaHandlingMode", inconsistentSchemaHandlingMode);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder maxBatchSize(String maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder maxQueueSize(String maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':',where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector,and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key.Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder messageKeyColumns(
                String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
        /**
         * Frequency in milliseconds to wait for new change events to appear
         * after receiving no events. Defaults to 500ms.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Frequency in milliseconds to wait for new change events to appear
         * after receiving no events. Defaults to 500ms.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder pollIntervalMs(
                String pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * The number of milliseconds to delay before a snapshot will begin.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotDelayMs(
                long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The number of milliseconds to delay before a snapshot will begin.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotDelayMs(
                String snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotFetchSize(
                int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotFetchSize(
                String snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * Controls how long the connector holds onto the global read lock while
         * it is performing a snapshot. The default is 'minimal', which means
         * the connector holds the global read lock (and thus prevents any
         * updates) for just the initial portion of the snapshot while the
         * database schemas and other metadata are being read. The remaining
         * work in a snapshot involves selecting all rows from each table, and
         * this can be done using the snapshot process' REPEATABLE READ
         * transaction even when the lock is no longer held and other operations
         * are updating the database. However, in some cases it may be desirable
         * to block all writes for the entire duration of the snapshot; in such
         * cases set this property to 'extended'. Using a value of 'none' will
         * prevent the connector from acquiring any table locks during the
         * snapshot process. This mode can only be used in combination with
         * snapshot.mode values of 'schema_only' or 'schema_only_recovery' and
         * is only safe to use if no schema changes are happening while the
         * snapshot is taken.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotLockingMode(
                String snapshotLockingMode) {
            doSetProperty("snapshotLockingMode", snapshotLockingMode);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Options include: 'when_needed' to specify that the connector run a
         * snapshot upon startup whenever it deems it necessary; 'initial' (the
         * default) to specify the connector can run a snapshot only when no
         * offsets are available for the logical server name; 'initial_only'
         * same as 'initial' except the connector should stop after completing
         * the snapshot and before it would normally read the binlog; and'never'
         * to specify the connector should never run a snapshot and that upon
         * first startup the connector should read from the beginning of the
         * binlog. The 'never' mode should be used with care, and only when the
         * binlog is known to contain all history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotMode(String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * BETA FEATURE: On connector restart, the connector will check if there
         * have been any new tables added to the configuration, and snapshot
         * them. There is presently only two options:'off': Default behavior. Do
         * not snapshot new tables.'parallel': The snapshot of the new tables
         * will occur in parallel to the continued binlog reading of the old
         * tables. When the snapshot completes, an independent binlog reader
         * will begin reading the events for the new tables until it catches up
         * to present time. At this point, both old and new binlog readers will
         * be momentarily halted and new binlog reader will start that will read
         * the binlog for all configured tables. The parallel binlog reader will
         * have a configured server id of 10000 the primary binlog reader's
         * server id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotNewTables(
                String snapshotNewTables) {
            doSetProperty("snapshotNewTables", snapshotNewTables);
            return this;
        }
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * thespecific connectors . Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder snapshotSelectStatementOverrides(
                String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
        /**
         * A version of the format of the publicly visible source part in the
         * message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder sourceStructVersion(
                String sourceStructVersion) {
            doSetProperty("sourceStructVersion", sourceStructVersion);
            return this;
        }
        /**
         * Description is not available here, please check Debezium website for
         * corresponding key 'table.blacklist' description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder tableBlacklist(
                String tableBlacklist) {
            doSetProperty("tableBlacklist", tableBlacklist);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder tableIgnoreBuiltin(
                boolean tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder tableIgnoreBuiltin(
                String tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder tableWhitelist(
                String tableWhitelist) {
            doSetProperty("tableWhitelist", tableWhitelist);
            return this;
        }
        /**
         * Time, date and timestamps can be represented with different kinds of
         * precisions, including:'adaptive_time_microseconds': the precision of
         * date and timestamp values is based the database column's precision;
         * but time fields always use microseconds precision;'connect': always
         * represents time, date and timestamp values using Kafka Connect's
         * built-in representations for Time, Date, and Timestamp, which uses
         * millisecond precision regardless of the database columns' precision.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder timePrecisionMode(
                String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder tombstonesOnDelete(
                boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsquenttombstone event (true) or only by a delete event (false).
         * Emitting the tombstone event (the default behavior) allows Kafka to
         * completely delete all events pertaining to the given key once the
         * source record got deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: mysql
         */
        default DebeziumMySqlEndpointBuilder tombstonesOnDelete(
                String tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Debezium MySQL Connector component.
     */
    public interface AdvancedDebeziumMySqlEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default DebeziumMySqlEndpointBuilder basic() {
            return (DebeziumMySqlEndpointBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMySqlEndpointBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMySqlEndpointBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMySqlEndpointBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedDebeziumMySqlEndpointBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDebeziumMySqlEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDebeziumMySqlEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDebeziumMySqlEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedDebeziumMySqlEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Debezium MySQL Connector (camel-debezium-mysql)
     * Represents a Debezium MySQL endpoint which is used to capture changes in
     * MySQL database so that that applications can see those changes and
     * respond to them.
     * 
     * Category: database,sql,mysql
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mysql
     * 
     * Syntax: <code>debezium-mysql:name</code>
     * 
     * Path parameter: name (required)
     * Unique name for the connector. Attempting to register again with the same
     * name will fail.
     */
    default DebeziumMySqlEndpointBuilder debeziumMysql(String path) {
        class DebeziumMySqlEndpointBuilderImpl extends AbstractEndpointBuilder implements DebeziumMySqlEndpointBuilder, AdvancedDebeziumMySqlEndpointBuilder {
            public DebeziumMySqlEndpointBuilderImpl(String path) {
                super("debezium-mysql", path);
            }
        }
        return new DebeziumMySqlEndpointBuilderImpl(path);
    }
}