/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceConsumer;
import org.apache.camel.component.azure.queue.QueueServiceProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="azure-queue", title="Azure Storage Queue Service", syntax="azure-blob:containerAndQueueUri", label="cloud,queue,azure")
public class QueueServiceEndpoint
extends DefaultEndpoint {
    @UriPath(description="Container Queue compact Uri")
    @Metadata(required=true)
    private String containerAndQueueUri;
    @UriParam
    private QueueServiceConfiguration configuration;

    public QueueServiceEndpoint(String uri, Component comp, QueueServiceConfiguration configuration) {
        super(uri, comp);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.log.trace("Creating a consumer");
        QueueServiceConsumer consumer = new QueueServiceConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        this.log.trace("Creating a producer");
        return new QueueServiceProducer((Endpoint)this);
    }

    public QueueServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(QueueServiceConfiguration configuration) {
        this.configuration = configuration;
    }
}

