/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.MongoClient;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbOperation;
import org.apache.camel.component.mongodb.meta.MongoDBMetaExtension;
import org.apache.camel.component.mongodb.verifier.MongoComponentVerifierExtension;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="mongodb")
public class MongoDbComponent
extends DefaultComponent {
    public static final Set<MongoDbOperation> WRITE_OPERATIONS = new HashSet<MongoDbOperation>(Arrays.asList(MongoDbOperation.insert, MongoDbOperation.save, MongoDbOperation.update, MongoDbOperation.remove));
    private MongoClient mongoConnection;

    public MongoDbComponent() {
        this(null);
    }

    public MongoDbComponent(CamelContext context) {
        super(context);
        this.registerExtension(MongoComponentVerifierExtension::new);
        this.registerExtension(MongoDBMetaExtension::new);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MongoDbEndpoint endpoint = new MongoDbEndpoint(uri, this);
        endpoint.setConnectionBean(remaining);
        endpoint.setMongoConnection(this.mongoConnection);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public MongoClient getMongoConnection() {
        return this.mongoConnection;
    }

    public void setMongoConnection(MongoClient mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
    }

    public static CamelMongoDbException wrapInCamelMongoDbException(Throwable t) {
        if (t instanceof CamelMongoDbException) {
            return (CamelMongoDbException)t;
        }
        return new CamelMongoDbException(t);
    }
}

