/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;

public class NatsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return NatsEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return NatsEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "topic": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setTopic((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "connection": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setConnection((Connection)NatsEndpointConfigurer.property((CamelContext)camelContext, Connection.class, (Object)value));
                return true;
            }
            case "reconnect": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setReconnect((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pedantic": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setPedantic((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "verbose": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setVerbose((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "reconnectTimeWait": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setReconnectTimeWait((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxReconnectAttempts": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setMaxReconnectAttempts((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "pingInterval": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setPingInterval((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "connectionTimeout": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setConnectionTimeout((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxPingsOut": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setMaxPingsOut((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "requestCleanupInterval": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setRequestCleanupInterval((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replySubject": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setReplySubject((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "noRandomizeServers": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setNoRandomizeServers((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "noEcho": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setNoEcho((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "queueName": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setQueueName((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxMessages": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setMaxMessages((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "poolSize": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setPoolSize((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "flushConnection": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setFlushConnection((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "flushTimeout": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setFlushTimeout((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "secure": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setSecure((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sslContextParameters": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setSslContextParameters((SSLContextParameters)NatsEndpointConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((NatsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((NatsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((NatsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)NatsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((NatsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)NatsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((NatsEndpoint)((Object)endpoint)).setSynchronous((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((NatsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "topic": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setTopic((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "connection": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setConnection((Connection)NatsEndpointConfigurer.property((CamelContext)camelContext, Connection.class, (Object)value));
                return true;
            }
            case "reconnect": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setReconnect((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pedantic": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setPedantic((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "verbose": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setVerbose((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "reconnecttimewait": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setReconnectTimeWait((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxreconnectattempts": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setMaxReconnectAttempts((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "pinginterval": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setPingInterval((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "connectiontimeout": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setConnectionTimeout((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxpingsout": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setMaxPingsOut((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "requestcleanupinterval": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setRequestCleanupInterval((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "replysubject": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setReplySubject((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "norandomizeservers": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setNoRandomizeServers((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "noecho": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setNoEcho((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "queuename": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setQueueName((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "maxmessages": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setMaxMessages((String)NatsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "poolsize": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setPoolSize((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "flushconnection": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setFlushConnection((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "flushtimeout": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setFlushTimeout((Integer)NatsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "secure": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setSecure((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sslcontextparameters": {
                ((NatsEndpoint)((Object)endpoint)).getConfiguration().setSslContextParameters((SSLContextParameters)NatsEndpointConfigurer.property((CamelContext)camelContext, SSLContextParameters.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((NatsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((NatsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((NatsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)NatsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((NatsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)NatsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((NatsEndpoint)((Object)endpoint)).setSynchronous((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((NatsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)NatsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

