/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp;

import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.amqp.AMQPConfiguration;
import org.apache.camel.component.amqp.AMQPConnectionDetails;
import org.apache.camel.component.amqp.AMQPJmsBinding;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.qpid.jms.JmsConnectionFactory;

@Component(value="amqp")
public class AMQPComponent
extends JmsComponent {
    public AMQPComponent() {
    }

    public AMQPComponent(JmsConfiguration configuration) {
        super(configuration);
    }

    public AMQPComponent(CamelContext context) {
        super(context);
    }

    public AMQPComponent(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    public static AMQPComponent amqpComponent(String uri) {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory(uri);
        connectionFactory.setTopicPrefix("topic://");
        return new AMQPComponent((ConnectionFactory)connectionFactory);
    }

    public static AMQPComponent amqpComponent(String uri, String username, String password) {
        JmsConnectionFactory connectionFactory = new JmsConnectionFactory(username, password, uri);
        connectionFactory.setTopicPrefix("topic://");
        return new AMQPComponent((ConnectionFactory)connectionFactory);
    }

    protected void doStart() throws Exception {
        Set connectionDetails = this.getCamelContext().getRegistry().findByType(AMQPConnectionDetails.class);
        if (connectionDetails.size() == 1) {
            AMQPConnectionDetails details = (AMQPConnectionDetails)connectionDetails.iterator().next();
            JmsConnectionFactory connectionFactory = new JmsConnectionFactory(details.username(), details.password(), details.uri());
            if (details.setTopicPrefix()) {
                connectionFactory.setTopicPrefix("topic://");
            }
            this.setConnectionFactory((ConnectionFactory)connectionFactory);
        }
        super.doStart();
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JmsEndpoint endpoint = (JmsEndpoint)super.createEndpoint(uri, remaining, parameters);
        endpoint.setBinding((JmsBinding)new AMQPJmsBinding(endpoint));
        return endpoint;
    }

    protected JmsConfiguration createConfiguration() {
        return new AMQPConfiguration();
    }

    public void setIncludeAmqpAnnotations(boolean includeAmqpAnnotations) {
        if (this.getConfiguration() instanceof AMQPConfiguration) {
            ((AMQPConfiguration)this.getConfiguration()).setIncludeAmqpAnnotations(includeAmqpAnnotations);
        }
    }
}

