/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.namespaces;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.consumer.common.NamespaceEvent;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;

public class KubernetesNamespacesConsumer
extends DefaultConsumer {
    private final Processor processor;
    private ExecutorService executor;
    private NamespacesConsumerTask nsWatcher;

    public KubernetesNamespacesConsumer(AbstractKubernetesEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.processor = processor;
    }

    public AbstractKubernetesEndpoint getEndpoint() {
        return (AbstractKubernetesEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().createExecutor();
        this.nsWatcher = new NamespacesConsumerTask();
        this.executor.submit(this.nsWatcher);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.log.debug("Stopping Kubernetes Namespace Consumer");
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                if (this.nsWatcher != null) {
                    this.nsWatcher.getWatch().close();
                }
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            } else {
                if (this.nsWatcher != null) {
                    this.nsWatcher.getWatch().close();
                }
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
    }

    class NamespacesConsumerTask
    implements Runnable {
        private Watch watch;

        NamespacesConsumerTask() {
        }

        @Override
        public void run() {
            NonNamespaceOperation w = KubernetesNamespacesConsumer.this.getEndpoint().getKubernetesClient().namespaces();
            if (ObjectHelper.isNotEmpty((Object)KubernetesNamespacesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace())) {
                w.withName(KubernetesNamespacesConsumer.this.getEndpoint().getKubernetesConfiguration().getNamespace());
            }
            this.watch = (Watch)w.watch((Object)new Watcher<Namespace>(){

                public void eventReceived(Watcher.Action action, Namespace resource) {
                    NamespaceEvent ne = new NamespaceEvent(action, resource);
                    Exchange exchange = KubernetesNamespacesConsumer.this.getEndpoint().createExchange();
                    exchange.getIn().setBody((Object)ne.getNamespace());
                    exchange.getIn().setHeader("CamelKubernetesEventAction", (Object)ne.getAction());
                    exchange.getIn().setHeader("CamelKubernetesEventTimestamp", (Object)System.currentTimeMillis());
                    try {
                        KubernetesNamespacesConsumer.this.processor.process(exchange);
                    }
                    catch (Exception e) {
                        KubernetesNamespacesConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)e);
                    }
                }

                public void onClose(KubernetesClientException cause) {
                    if (cause != null) {
                        KubernetesNamespacesConsumer.this.log.error(cause.getMessage(), (Throwable)cause);
                    }
                }
            });
        }

        public Watch getWatch() {
            return this.watch;
        }

        public void setWatch(Watch watch) {
            this.watch = watch;
        }
    }
}

