/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;

public abstract class DefaultProducer
extends ServiceSupport
implements Producer {
    private transient String producerToString;
    private final Endpoint endpoint;

    public DefaultProducer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        if (this.producerToString == null) {
            this.producerToString = "Producer[" + URISupport.sanitizeUri((String)this.endpoint.getEndpointUri()) + "]";
        }
        return this.producerToString;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Exchange createExchange() {
        return this.endpoint.createExchange();
    }

    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    protected void doStart() throws Exception {
        if (this.isSingleton()) {
            this.log.debug("Starting producer: {}", (Object)this);
        } else {
            this.log.trace("Starting producer: {}", (Object)this);
        }
    }

    protected void doStop() throws Exception {
        if (this.isSingleton()) {
            this.log.debug("Stopping producer: {}", (Object)this);
        } else {
            this.log.trace("Stopping producer: {}", (Object)this);
        }
    }
}

