/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.websocket.jsr356.ClientSessions;
import org.apache.camel.websocket.jsr356.JSR356Endpoint;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;

public class JSR356Producer
extends DefaultAsyncProducer {
    private final int sessionCount;
    private ClientSessions manager;
    private BiConsumer<Exchange, AsyncCallback> onExchange;

    JSR356Producer(JSR356Endpoint jsr356Endpoint, int sessionCount) {
        super((Endpoint)jsr356Endpoint);
        this.sessionCount = sessionCount;
    }

    public JSR356Endpoint getEndpoint() {
        return (JSR356Endpoint)((Object)JSR356Endpoint.class.cast(super.getEndpoint()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Session session = (Session)exchange.getIn().getHeader("jsr356.session", Session.class);
        if (session != null && ((Boolean)exchange.getIn().getHeader("jsr356.producer.session.incoming.use", (Object)false, Boolean.class)).booleanValue()) {
            Session session2 = session;
            synchronized (session2) {
                this.doSend(exchange, session);
            }
        } else {
            this.onExchange.accept(exchange, callback);
        }
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String endpointKey = this.getEndpoint().getEndpointUri().substring("websocket-jsr356://".length());
        if (!endpointKey.contains("://")) {
            throw new IllegalArgumentException("You should pass a client uri");
        }
        ClientEndpointConfig.Builder clientConfig = ClientEndpointConfig.Builder.create();
        this.manager = new ClientSessions(this.sessionCount, URI.create(endpointKey), clientConfig.build(), null);
        this.manager.prepare();
        this.onExchange = (ex, cb) -> this.manager.execute(session -> this.doSend((Exchange)ex, (Session)session));
    }

    private void doSend(Exchange ex, Session session) {
        try {
            JSR356WebSocketComponent.sendMessage(session, ex.getIn().getBody());
        }
        catch (IOException e) {
            ex.setException((Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        Optional.ofNullable(this.manager).ifPresent(ClientSessions::close);
        super.doStop();
    }
}

