/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.metrics.AbstractMetricsProducer;
import org.apache.camel.component.metrics.MetricsEndpoint;

public class HistogramProducer
extends AbstractMetricsProducer {
    public HistogramProducer(MetricsEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MetricsEndpoint endpoint, MetricRegistry registry, String metricsName) throws Exception {
        Message in = exchange.getIn();
        Histogram histogram = registry.histogram(metricsName);
        Long value = endpoint.getValue();
        Long finalValue = this.getLongHeader(in, "CamelMetricsHistogramValue", value);
        if (finalValue != null) {
            histogram.update(finalValue.longValue());
        } else {
            this.log.warn("Cannot update histogram \"{}\" with null value", (Object)metricsName);
        }
    }
}

