/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import com.google.common.base.Preconditions;
import org.apache.camel.component.wordpress.api.model.Context;
import org.apache.camel.component.wordpress.api.model.DeletedModel;
import org.apache.camel.component.wordpress.api.model.SearchCriteria;
import org.apache.camel.component.wordpress.api.service.WordpressCrudService;
import org.apache.camel.component.wordpress.api.service.impl.AbstractWordpressServiceAdapter;

abstract class AbstractWordpressCrudServiceAdapter<A, T, S extends SearchCriteria>
extends AbstractWordpressServiceAdapter<A>
implements WordpressCrudService<T, S> {
    AbstractWordpressCrudServiceAdapter(String wordpressUrl, String apiVersion) {
        super(wordpressUrl, apiVersion);
    }

    @Override
    public final T create(T object) {
        Preconditions.checkNotNull(object, (Object)"Please define an object to create");
        return this.doCreate(object);
    }

    protected abstract T doCreate(T var1);

    @Override
    public final T delete(Integer id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"The id is mandatory");
        return this.doDelete(id);
    }

    @Override
    public final DeletedModel<T> forceDelete(Integer id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"The id is mandatory");
        return this.doForceDelete(id);
    }

    protected abstract T doDelete(Integer var1);

    protected DeletedModel<T> doForceDelete(Integer id) {
        DeletedModel<T> deletedModel = new DeletedModel<T>();
        deletedModel.setPrevious(this.doDelete(id));
        deletedModel.setDeleted(false);
        return deletedModel;
    }

    @Override
    public final T update(Integer id, T object) {
        Preconditions.checkNotNull(object, (Object)"Please define an object to update");
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"The id is mandatory");
        return this.doUpdate(id, object);
    }

    protected abstract T doUpdate(Integer var1, T var2);

    @Override
    public T retrieve(Integer entityID) {
        return this.retrieve(entityID, Context.view);
    }

    @Override
    public final T retrieve(Integer entityID, Context context) {
        Preconditions.checkArgument((entityID > 0 ? 1 : 0) != 0, (Object)"Please provide a non zero id");
        Preconditions.checkNotNull((Object)((Object)context), (Object)"Provide a context");
        return this.doRetrieve(entityID, context);
    }

    protected abstract T doRetrieve(Integer var1, Context var2);
}

