/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jcr;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jcr.EndpointEventListener;
import org.apache.camel.component.jcr.JcrEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;

public class JcrConsumer
extends DefaultConsumer {
    private Session session;
    private EventListener eventListener;
    private ScheduledFuture<?> sessionListenerCheckerScheduledFuture;

    public JcrConsumer(JcrEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.scheduleSessionListenerChecker();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.cancelSessionListenerChecker();
        this.unregisterListenerAndLogoutSession();
    }

    protected JcrEndpoint getJcrEndpoint() {
        JcrEndpoint endpoint = (JcrEndpoint)this.getEndpoint();
        return endpoint;
    }

    private synchronized void createSessionAndRegisterListener() throws RepositoryException {
        this.log.trace("createSessionAndRegisterListener START");
        this.session = ObjectHelper.isEmpty((Object)this.getJcrEndpoint().getWorkspaceName()) ? this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials()) : this.getJcrEndpoint().getRepository().login(this.getJcrEndpoint().getCredentials(), this.getJcrEndpoint().getWorkspaceName());
        int eventTypes = this.getJcrEndpoint().getEventTypes();
        String absPath = this.getJcrEndpoint().getBase();
        if (absPath == null) {
            absPath = "/";
        } else if (!absPath.startsWith("/")) {
            absPath = "/" + absPath;
        }
        boolean isDeep = this.getJcrEndpoint().isDeep();
        Object[] uuid = null;
        String uuids = this.getJcrEndpoint().getUuids();
        if (uuids != null && !"".equals(uuids = uuids.trim())) {
            uuid = uuids.split(",");
        }
        Object[] nodeTypeName = null;
        String nodeTypeNames = this.getJcrEndpoint().getNodeTypeNames();
        if (nodeTypeNames != null && !"".equals(nodeTypeNames = nodeTypeNames.trim())) {
            nodeTypeName = nodeTypeNames.split(",");
        }
        boolean noLocal = this.getJcrEndpoint().isNoLocal();
        this.eventListener = new EndpointEventListener(this.getJcrEndpoint(), this.getProcessor());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding JCR Event Listener, {}, on {}. eventTypes=" + eventTypes + ", isDeep=" + isDeep + ", uuid=" + Arrays.toString(uuid) + ", nodeTypeName=" + Arrays.toString(nodeTypeName) + ", noLocal=" + noLocal, (Object)this.eventListener, (Object)absPath);
        }
        this.session.getWorkspace().getObservationManager().addEventListener(this.eventListener, eventTypes, absPath, isDeep, (String[])uuid, (String[])nodeTypeName, noLocal);
        this.log.trace("createSessionAndRegisterListener END");
    }

    private synchronized void unregisterListenerAndLogoutSession() throws RepositoryException {
        this.log.trace("unregisterListenerAndLogoutSession START");
        if (this.session != null) {
            try {
                if (!this.session.isLive()) {
                    this.log.info("Session was is no more live.");
                } else {
                    if (this.eventListener != null) {
                        this.session.getWorkspace().getObservationManager().removeEventListener(this.eventListener);
                        this.eventListener = null;
                    }
                    this.session.logout();
                }
            }
            finally {
                this.eventListener = null;
                this.session = null;
            }
        }
        this.log.trace("unregisterListenerAndLogoutSession END");
    }

    private void cancelSessionListenerChecker() {
        if (this.sessionListenerCheckerScheduledFuture != null) {
            this.sessionListenerCheckerScheduledFuture.cancel(true);
        }
    }

    private void scheduleSessionListenerChecker() {
        String name = "JcrConsumerSessionChecker[" + this.getJcrEndpoint().getEndpointConfiguredDestinationName() + "]";
        ScheduledExecutorService executor = this.getJcrEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, name);
        JcrConsumerSessionListenerChecker sessionListenerChecker = new JcrConsumerSessionListenerChecker();
        long sessionLiveCheckIntervalOnStart = this.getJcrEndpoint().getSessionLiveCheckIntervalOnStart();
        long sessionLiveCheckInterval = this.getJcrEndpoint().getSessionLiveCheckInterval();
        this.sessionListenerCheckerScheduledFuture = executor.scheduleWithFixedDelay(sessionListenerChecker, sessionLiveCheckIntervalOnStart, sessionLiveCheckInterval, TimeUnit.MILLISECONDS);
    }

    private class JcrConsumerSessionListenerChecker
    implements Runnable {
        private JcrConsumerSessionListenerChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JcrConsumer.this.log.debug("JcrConsumerSessionListenerChecker starts.");
            boolean isSessionLive = false;
            JcrConsumerSessionListenerChecker jcrConsumerSessionListenerChecker = this;
            synchronized (jcrConsumerSessionListenerChecker) {
                if (JcrConsumer.this.session != null) {
                    try {
                        isSessionLive = JcrConsumer.this.session.isLive();
                    }
                    catch (Exception e) {
                        JcrConsumer.this.log.debug("Exception while checking jcr session", (Throwable)e);
                    }
                }
            }
            if (!isSessionLive) {
                try {
                    JcrConsumer.this.createSessionAndRegisterListener();
                }
                catch (RepositoryException e) {
                    JcrConsumer.this.log.error("Failed to create session and register listener", (Throwable)e);
                }
            }
            JcrConsumer.this.log.debug("JcrConsumerSessionListenerChecker stops.");
        }
    }
}

