/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ReactiveStreamsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return ReactiveStreamsEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return ReactiveStreamsEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "maxInflightExchanges": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setMaxInflightExchanges((Integer)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "exchangesRefillLowWatermark": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setExchangesRefillLowWatermark((Double)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Double.TYPE, (Object)value));
                return true;
            }
            case "concurrentConsumers": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setConcurrentConsumers((Integer)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "forwardOnComplete": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setForwardOnComplete((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forwardOnError": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setForwardOnError((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "backpressureStrategy": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setBackpressureStrategy((ReactiveStreamsBackpressureStrategy)((Object)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, ReactiveStreamsBackpressureStrategy.class, (Object)value)));
                return true;
            }
            case "lazyStartProducer": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setSynchronous((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "maxinflightexchanges": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setMaxInflightExchanges((Integer)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "exchangesrefilllowwatermark": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setExchangesRefillLowWatermark((Double)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Double.TYPE, (Object)value));
                return true;
            }
            case "concurrentconsumers": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setConcurrentConsumers((Integer)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "forwardoncomplete": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setForwardOnComplete((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "forwardonerror": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setForwardOnError((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "backpressurestrategy": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setBackpressureStrategy((ReactiveStreamsBackpressureStrategy)((Object)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, ReactiveStreamsBackpressureStrategy.class, (Object)value)));
                return true;
            }
            case "lazystartproducer": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setSynchronous((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((ReactiveStreamsEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ReactiveStreamsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

