/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ecs;

import com.amazonaws.Protocol;
import com.amazonaws.services.ecs.AmazonECS;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.aws.ecs.ECSEndpoint;
import org.apache.camel.component.aws.ecs.ECSOperations;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ECSEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return ECSEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return ECSEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "ecsClient": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setEcsClient((AmazonECS)ECSEndpointConfigurer.property((CamelContext)camelContext, AmazonECS.class, (Object)value));
                return true;
            }
            case "accessKey": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretKey": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setOperation((ECSOperations)((Object)ECSEndpointConfigurer.property((CamelContext)camelContext, ECSOperations.class, (Object)value)));
                return true;
            }
            case "proxyProtocol": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)ECSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyHost": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyPort": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((ECSEndpoint)((Object)endpoint)).setStartScheduler((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((ECSEndpoint)((Object)endpoint)).setInitialDelay((Long)ECSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((ECSEndpoint)((Object)endpoint)).setDelay((Long)ECSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((ECSEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)ECSEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((ECSEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((ECSEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)ECSEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((ECSEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)ECSEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((ECSEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((ECSEndpoint)((Object)endpoint)).setGreedy((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((ECSEndpoint)((Object)endpoint)).setScheduler((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((ECSEndpoint)((Object)endpoint)).setSchedulerProperties((Map)ECSEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((ECSEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)ECSEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((ECSEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((ECSEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((ECSEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatCount": {
                ((ECSEndpoint)((Object)endpoint)).setRepeatCount((Long)ECSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((ECSEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((ECSEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((ECSEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ECSEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((ECSEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ECSEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ECSEndpoint)((Object)endpoint)).setSynchronous((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((ECSEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "ecsclient": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setEcsClient((AmazonECS)ECSEndpointConfigurer.property((CamelContext)camelContext, AmazonECS.class, (Object)value));
                return true;
            }
            case "accesskey": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setAccessKey((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setSecretKey((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setOperation((ECSOperations)((Object)ECSEndpointConfigurer.property((CamelContext)camelContext, ECSOperations.class, (Object)value)));
                return true;
            }
            case "proxyprotocol": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setProxyProtocol((Protocol)ECSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "proxyhost": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setProxyHost((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setProxyPort((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "region": {
                ((ECSEndpoint)((Object)endpoint)).getConfiguration().setRegion((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((ECSEndpoint)((Object)endpoint)).setStartScheduler((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((ECSEndpoint)((Object)endpoint)).setInitialDelay((Long)ECSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((ECSEndpoint)((Object)endpoint)).setDelay((Long)ECSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((ECSEndpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)ECSEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((ECSEndpoint)((Object)endpoint)).setUseFixedDelay((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((ECSEndpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)ECSEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((ECSEndpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)ECSEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((ECSEndpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((ECSEndpoint)((Object)endpoint)).setGreedy((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((ECSEndpoint)((Object)endpoint)).setScheduler((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((ECSEndpoint)((Object)endpoint)).setSchedulerProperties((Map)ECSEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((ECSEndpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)ECSEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((ECSEndpoint)((Object)endpoint)).setBackoffMultiplier((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((ECSEndpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((ECSEndpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "repeatcount": {
                ((ECSEndpoint)((Object)endpoint)).setRepeatCount((Long)ECSEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((ECSEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((ECSEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((ECSEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)ECSEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((ECSEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)ECSEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((ECSEndpoint)((Object)endpoint)).setSynchronous((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((ECSEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

