/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.infinispan.InfinispanCustomListener;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.component.infinispan.InfinispanQueryBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.infinispan.commons.api.BasicCacheContainer;

public class InfinispanEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return InfinispanEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return InfinispanEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "hosts": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setHosts((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setOperation((InfinispanOperation)((Object)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanOperation.class, (Object)value)));
                return true;
            }
            case "command": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCommand((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sync": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setSync((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "eventTypes": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setEventTypes((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customListener": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCustomListener((InfinispanCustomListener)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanCustomListener.class, (Object)value));
                return true;
            }
            case "clusteredListener": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setClusteredListener((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "queryBuilder": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setQueryBuilder((InfinispanQueryBuilder)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanQueryBuilder.class, (Object)value));
                return true;
            }
            case "flags": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setFlags((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configurationUri": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setConfigurationUri((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configurationProperties": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setConfigurationProperties((Map)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "cacheContainer": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCacheContainer((BasicCacheContainer)InfinispanEndpointConfigurer.property((CamelContext)camelContext, BasicCacheContainer.class, (Object)value));
                return true;
            }
            case "cacheContainerConfiguration": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCacheContainerConfiguration(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "resultHeader": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setResultHeader(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "remappingFunction": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setRemappingFunction((BiFunction)InfinispanEndpointConfigurer.property((CamelContext)camelContext, BiFunction.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((InfinispanEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((InfinispanEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((InfinispanEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)InfinispanEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((InfinispanEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)InfinispanEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((InfinispanEndpoint)((Object)endpoint)).setSynchronous((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((InfinispanEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "hosts": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setHosts((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setOperation((InfinispanOperation)((Object)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanOperation.class, (Object)value)));
                return true;
            }
            case "command": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCommand((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sync": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setSync((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "eventtypes": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setEventTypes((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "customlistener": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCustomListener((InfinispanCustomListener)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanCustomListener.class, (Object)value));
                return true;
            }
            case "clusteredlistener": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setClusteredListener((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "querybuilder": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setQueryBuilder((InfinispanQueryBuilder)InfinispanEndpointConfigurer.property((CamelContext)camelContext, InfinispanQueryBuilder.class, (Object)value));
                return true;
            }
            case "flags": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setFlags((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configurationuri": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setConfigurationUri((String)InfinispanEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configurationproperties": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setConfigurationProperties((Map)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "cachecontainer": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCacheContainer((BasicCacheContainer)InfinispanEndpointConfigurer.property((CamelContext)camelContext, BasicCacheContainer.class, (Object)value));
                return true;
            }
            case "cachecontainerconfiguration": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setCacheContainerConfiguration(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "resultheader": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setResultHeader(InfinispanEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "remappingfunction": {
                ((InfinispanEndpoint)((Object)endpoint)).getConfiguration().setRemappingFunction((BiFunction)InfinispanEndpointConfigurer.property((CamelContext)camelContext, BiFunction.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((InfinispanEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((InfinispanEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((InfinispanEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)InfinispanEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((InfinispanEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)InfinispanEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((InfinispanEndpoint)((Object)endpoint)).setSynchronous((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((InfinispanEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)InfinispanEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

