/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.core.DestinationResolver;

public class SpringIntegrationProducer
extends DefaultProducer
implements Processor {
    private final DestinationResolver<MessageChannel> destinationResolver;
    private DirectChannel inputChannel;
    private MessageChannel outputChannel;

    public SpringIntegrationProducer(SpringCamelContext context, SpringIntegrationEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.destinationResolver = new BeanFactoryChannelResolver((BeanFactory)context.getApplicationContext());
    }

    public SpringIntegrationEndpoint getEndpoint() {
        return (SpringIntegrationEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getEndpoint().getMessageChannel() == null) {
            String outputChannelName = this.getEndpoint().getDefaultChannel();
            if (ObjectHelper.isEmpty((Object)outputChannelName)) {
                outputChannelName = this.getEndpoint().getInputChannel();
            }
            StringHelper.notEmpty((String)outputChannelName, (String)"OutputChannelName", (Object)((Object)this.getEndpoint()));
            this.outputChannel = (MessageChannel)this.destinationResolver.resolveDestination(outputChannelName);
        } else {
            this.outputChannel = this.getEndpoint().getMessageChannel();
        }
        if (this.outputChannel == null) {
            throw new IllegalArgumentException("Cannot resolve OutputChannel on " + (Object)((Object)this.getEndpoint()));
        }
        if (this.getEndpoint().isInOut()) {
            StringHelper.notEmpty((String)this.getEndpoint().getInputChannel(), (String)"InputChannel", (Object)((Object)this.getEndpoint()));
            this.inputChannel = (DirectChannel)this.destinationResolver.resolveDestination(this.getEndpoint().getInputChannel());
            if (this.inputChannel == null) {
                throw new IllegalArgumentException("Cannot resolve InputChannel on " + (Object)((Object)this.getEndpoint()));
            }
        }
    }

    public void process(final Exchange exchange) throws Exception {
        if (exchange.getPattern().isOutCapable()) {
            if (this.inputChannel == null) {
                throw new IllegalArgumentException("InputChannel has not been configured on " + (Object)((Object)this.getEndpoint()));
            }
            exchange.getIn().getHeaders().put("replyChannel", this.inputChannel);
            this.inputChannel.subscribe(new MessageHandler(){

                public void handleMessage(Message<?> message) {
                    SpringIntegrationProducer.this.log.debug("Received {} from InputChannel: {}", message, (Object)SpringIntegrationProducer.this.inputChannel);
                    SpringIntegrationBinding.storeToCamelMessage(message, exchange.getOut());
                }
            });
        }
        Message<?> siOutmessage = SpringIntegrationBinding.createSpringIntegrationMessage(exchange);
        this.log.debug("Sending {} to OutputChannel: {}", siOutmessage, (Object)this.outputChannel);
        this.outputChannel.send(siOutmessage);
    }
}

