/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.camel.util.StringHelper;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class OsgiServletRegisterer {
    private String alias;
    private String servletName = "CamelServlet";
    private HttpServlet servlet;
    private HttpService httpService;
    private HttpContext httpContext;
    private boolean alreadyRegistered;
    private volatile boolean matchOnUriPrefix = true;

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setServlet(HttpServlet servlet) {
        this.servlet = servlet;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setMatchOnUriPrefix(boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public void register() throws Exception {
        StringHelper.notEmpty((String)this.alias, (String)"alias", (Object)this);
        StringHelper.notEmpty((String)this.servletName, (String)"servletName", (Object)this);
        HttpContext actualHttpContext = this.httpContext == null ? this.httpService.createDefaultHttpContext() : this.httpContext;
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        ((Dictionary)initParams).put("matchOnUriPrefix", this.matchOnUriPrefix ? "true" : "false");
        ((Dictionary)initParams).put("servlet-name", this.servletName);
        this.httpService.registerServlet(this.alias, (Servlet)this.servlet, initParams, actualHttpContext);
        this.alreadyRegistered = true;
    }

    public void unregister() {
        if (this.alreadyRegistered) {
            this.httpService.unregister(this.alias);
            this.alreadyRegistered = false;
        }
    }
}

