/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.webhook;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.component.webhook.WebhookEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

@Component(value="webhook")
public class WebhookComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private WebhookConfiguration configuration;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String delegateUri = remaining;
        if (ObjectHelper.isEmpty((Object)delegateUri)) {
            throw new IllegalArgumentException("Wrong uri syntax : webhook:uri, got " + remaining);
        }
        WebhookConfiguration configuration = this.getConfiguration().copy();
        this.setProperties(configuration, parameters);
        RestConfiguration restConfig = this.getCamelContext().getRestConfiguration(configuration.getWebhookComponentName(), true);
        configuration.setRestConfiguration(restConfig);
        if (parameters != null && !parameters.isEmpty()) {
            delegateUri = delegateUri + "?" + URISupport.createQueryString(parameters);
        }
        configuration.setEndpointUri(delegateUri);
        return new WebhookEndpoint(uri, this, configuration, delegateUri);
    }

    public WebhookConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new WebhookConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(WebhookConfiguration configuration) {
        this.configuration = configuration;
    }
}

