/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kura;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RoutesDefinition;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KuraRouter
extends RouteBuilder
implements BundleActivator {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected BundleContext bundleContext;
    protected CamelContext camelContext;
    protected ProducerTemplate producerTemplate;
    protected ConsumerTemplate consumerTemplate;

    public void start(BundleContext bundleContext) throws Exception {
        try {
            Object routePropertyValue;
            this.bundleContext = bundleContext;
            this.log.debug("Initializing bundle {}.", (Object)bundleContext.getBundle().getBundleId());
            this.camelContext = this.createCamelContext();
            this.camelContext.addRoutes((RoutesBuilder)this);
            ConfigurationAdmin configurationAdmin = this.requiredService(ConfigurationAdmin.class);
            Configuration camelKuraConfig = configurationAdmin.getConfiguration(this.camelXmlRoutesPid());
            if (camelKuraConfig != null && camelKuraConfig.getProperties() != null && (routePropertyValue = camelKuraConfig.getProperties().get(this.camelXmlRoutesProperty())) != null) {
                ByteArrayInputStream routesXml = new ByteArrayInputStream(routePropertyValue.toString().getBytes());
                RoutesDefinition routes = ModelHelper.loadRoutesDefinition((CamelContext)this.camelContext, (InputStream)routesXml);
                ((Model)this.camelContext.getExtension(Model.class)).addRouteDefinitions((Collection)routes.getRoutes());
            }
            this.beforeStart(this.camelContext);
            this.log.debug("About to start Camel Kura router: {}", (Object)((Object)((Object)this)).getClass().getName());
            this.camelContext.start();
            this.producerTemplate = this.camelContext.createProducerTemplate();
            this.consumerTemplate = this.camelContext.createConsumerTemplate();
            this.log.debug("Bundle {} started.", (Object)bundleContext.getBundle().getBundleId());
        }
        catch (Throwable e) {
            String errorMessage = "Problem when starting Kura module " + ((Object)((Object)this)).getClass().getName() + ":";
            this.log.warn(errorMessage, e);
            System.err.println(errorMessage);
            e.printStackTrace();
            throw e;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.log.debug("Stopping bundle {}.", (Object)bundleContext.getBundle().getBundleId());
        this.camelContext.stop();
        this.log.debug("Bundle {} stopped.", (Object)bundleContext.getBundle().getBundleId());
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        this.start(componentContext.getBundleContext());
    }

    protected void deactivate(ComponentContext componentContext) throws Exception {
        this.stop(componentContext.getBundleContext());
    }

    public void configure() throws Exception {
        this.log.debug("No programmatic routes configuration found.");
    }

    protected CamelContext createCamelContext() {
        return new OsgiDefaultCamelContext(this.bundleContext);
    }

    protected void beforeStart(CamelContext camelContext) {
        this.log.debug("Empty KuraRouter CamelContext before start configuration - skipping.");
    }

    protected <T> T service(Class<T> serviceType) {
        ServiceReference reference = this.bundleContext.getServiceReference(serviceType.getName());
        return (T)(reference == null ? null : this.bundleContext.getService(reference));
    }

    protected <T> T requiredService(Class<T> serviceType) {
        ServiceReference reference = this.bundleContext.getServiceReference(serviceType.getName());
        if (reference == null) {
            throw new IllegalStateException("Cannot find service: " + serviceType.getName());
        }
        return (T)this.bundleContext.getService(reference);
    }

    protected String camelXmlRoutesPid() {
        return "kura.camel";
    }

    protected String camelXmlRoutesProperty() {
        return "kura.camel." + this.bundleContext.getBundle().getSymbolicName() + ".route";
    }
}

