/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.disruptor.DisruptorEndpoint;
import org.apache.camel.component.disruptor.DisruptorProducerType;
import org.apache.camel.component.disruptor.DisruptorWaitStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class DisruptorEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return DisruptorEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return DisruptorEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "concurrentConsumers": {
                ((DisruptorEndpoint)((Object)endpoint)).setConcurrentConsumers((Integer)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "multipleConsumers": {
                ((DisruptorEndpoint)((Object)endpoint)).setMultipleConsumers((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "waitForTaskToComplete": {
                ((DisruptorEndpoint)((Object)endpoint)).setWaitForTaskToComplete((WaitForTaskToComplete)DisruptorEndpointConfigurer.property((CamelContext)camelContext, WaitForTaskToComplete.class, (Object)value));
                return true;
            }
            case "timeout": {
                ((DisruptorEndpoint)((Object)endpoint)).setTimeout((Long)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "size": {
                ((DisruptorEndpoint)((Object)endpoint)).setSize((Integer)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "blockWhenFull": {
                ((DisruptorEndpoint)((Object)endpoint)).setBlockWhenFull((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "waitStrategy": {
                ((DisruptorEndpoint)((Object)endpoint)).setWaitStrategy((DisruptorWaitStrategy)((Object)DisruptorEndpointConfigurer.property((CamelContext)camelContext, DisruptorWaitStrategy.class, (Object)value)));
                return true;
            }
            case "producerType": {
                ((DisruptorEndpoint)((Object)endpoint)).setProducerType((DisruptorProducerType)((Object)DisruptorEndpointConfigurer.property((CamelContext)camelContext, DisruptorProducerType.class, (Object)value)));
                return true;
            }
            case "lazyStartProducer": {
                ((DisruptorEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((DisruptorEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((DisruptorEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DisruptorEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((DisruptorEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DisruptorEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DisruptorEndpoint)((Object)endpoint)).setSynchronous((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((DisruptorEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "concurrentconsumers": {
                ((DisruptorEndpoint)((Object)endpoint)).setConcurrentConsumers((Integer)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "multipleconsumers": {
                ((DisruptorEndpoint)((Object)endpoint)).setMultipleConsumers((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "waitfortasktocomplete": {
                ((DisruptorEndpoint)((Object)endpoint)).setWaitForTaskToComplete((WaitForTaskToComplete)DisruptorEndpointConfigurer.property((CamelContext)camelContext, WaitForTaskToComplete.class, (Object)value));
                return true;
            }
            case "timeout": {
                ((DisruptorEndpoint)((Object)endpoint)).setTimeout((Long)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "size": {
                ((DisruptorEndpoint)((Object)endpoint)).setSize((Integer)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "blockwhenfull": {
                ((DisruptorEndpoint)((Object)endpoint)).setBlockWhenFull((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "waitstrategy": {
                ((DisruptorEndpoint)((Object)endpoint)).setWaitStrategy((DisruptorWaitStrategy)((Object)DisruptorEndpointConfigurer.property((CamelContext)camelContext, DisruptorWaitStrategy.class, (Object)value)));
                return true;
            }
            case "producertype": {
                ((DisruptorEndpoint)((Object)endpoint)).setProducerType((DisruptorProducerType)((Object)DisruptorEndpointConfigurer.property((CamelContext)camelContext, DisruptorProducerType.class, (Object)value)));
                return true;
            }
            case "lazystartproducer": {
                ((DisruptorEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((DisruptorEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((DisruptorEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)DisruptorEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((DisruptorEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)DisruptorEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((DisruptorEndpoint)((Object)endpoint)).setSynchronous((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((DisruptorEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)DisruptorEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

