/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.stream;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamComponent;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.23.0", scheme="google-sheets-stream", title="Google Sheets Stream", syntax="google-sheets-stream:apiName", consumerOnly=true, label="api,cloud,sheets")
public class GoogleSheetsStreamEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private GoogleSheetsStreamConfiguration configuration;

    public GoogleSheetsStreamEndpoint(String uri, GoogleSheetsStreamComponent component, GoogleSheetsStreamConfiguration endpointConfiguration) {
        super(uri, (Component)component);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The camel google sheets stream component doesn't support producer");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        GoogleSheetsStreamConsumer consumer = new GoogleSheetsStreamConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Sheets getClient() {
        return ((GoogleSheetsStreamComponent)this.getComponent()).getClient(this.configuration);
    }

    public GoogleSheetsClientFactory getClientFactory() {
        return ((GoogleSheetsStreamComponent)this.getComponent()).getClientFactory();
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        ((GoogleSheetsStreamComponent)this.getComponent()).setClientFactory(clientFactory);
    }

    public GoogleSheetsStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public Exchange createExchange(int rangeIndex, ValueRange valueRange) {
        Exchange exchange = super.createExchange(this.getExchangePattern());
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetId", (Object)this.configuration.getSpreadsheetId());
        exchange.getIn().setHeader("CamelGoogleSheetsRange", (Object)valueRange.getRange());
        exchange.getIn().setHeader("CamelGoogleSheetsRangeIndex", (Object)rangeIndex);
        exchange.getIn().setHeader("CamelGoogleSheetsMajorDimension", (Object)valueRange.getMajorDimension());
        message.setBody((Object)valueRange);
        return exchange;
    }

    public Exchange createExchange(int rangeIndex, int valueIndex, String range, String majorDimension, List<Object> values) {
        Exchange exchange = super.createExchange(this.getExchangePattern());
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetId", (Object)this.configuration.getSpreadsheetId());
        exchange.getIn().setHeader("CamelGoogleSheetsRangeIndex", (Object)rangeIndex);
        exchange.getIn().setHeader("CamelGoogleSheetsValueIndex", (Object)valueIndex);
        exchange.getIn().setHeader("CamelGoogleSheetsRange", (Object)range);
        exchange.getIn().setHeader("CamelGoogleSheetsMajorDimension", (Object)majorDimension);
        message.setBody(values);
        return exchange;
    }

    public Exchange createExchange(Spreadsheet spreadsheet) {
        Exchange exchange = super.createExchange(this.getExchangePattern());
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetId", (Object)spreadsheet.getSpreadsheetId());
        exchange.getIn().setHeader("CamelGoogleSheetsSpreadsheetUrl", (Object)spreadsheet.getSpreadsheetUrl());
        message.setBody((Object)spreadsheet);
        return exchange;
    }
}

