/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.XMLSecurityDataFormat;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;

public class XMLSecurityDataFormatReifier
extends DataFormatReifier<XMLSecurityDataFormat> {
    private static final String DEFAULT_ENCRYPTION_ALG = "http://www.w3.org/2009/xmlenc11#aes256-gcm";

    public XMLSecurityDataFormatReifier(DataFormatDefinition definition) {
        super((XMLSecurityDataFormat)definition);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (((XMLSecurityDataFormat)this.definition).getSecureTag() != null) {
            this.setProperty(camelContext, dataFormat, "secureTag", ((XMLSecurityDataFormat)this.definition).getSecureTag());
        } else {
            this.setProperty(camelContext, dataFormat, "secureTag", "");
        }
        boolean isSecureTagContents = ((XMLSecurityDataFormat)this.definition).getSecureTagContents() != null && ((XMLSecurityDataFormat)this.definition).getSecureTagContents() != false;
        this.setProperty(camelContext, dataFormat, "secureTagContents", isSecureTagContents);
        if (((XMLSecurityDataFormat)this.definition).getPassPhrase() != null) {
            this.setProperty(camelContext, dataFormat, "passPhrase", ((XMLSecurityDataFormat)this.definition).getPassPhrase().getBytes());
        } else if (((XMLSecurityDataFormat)this.definition).getPassPhraseByte() != null) {
            this.setProperty(camelContext, dataFormat, "passPhrase", ((XMLSecurityDataFormat)this.definition).getPassPhraseByte());
        }
        if (((XMLSecurityDataFormat)this.definition).getXmlCipherAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "xmlCipherAlgorithm", ((XMLSecurityDataFormat)this.definition).getXmlCipherAlgorithm());
        } else {
            this.setProperty(camelContext, dataFormat, "xmlCipherAlgorithm", DEFAULT_ENCRYPTION_ALG);
        }
        if (((XMLSecurityDataFormat)this.definition).getKeyCipherAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "keyCipherAlgorithm", ((XMLSecurityDataFormat)this.definition).getKeyCipherAlgorithm());
        }
        if (((XMLSecurityDataFormat)this.definition).getRecipientKeyAlias() != null) {
            this.setProperty(camelContext, dataFormat, "recipientKeyAlias", ((XMLSecurityDataFormat)this.definition).getRecipientKeyAlias());
        }
        if (((XMLSecurityDataFormat)this.definition).getKeyOrTrustStoreParametersRef() != null) {
            this.setProperty(camelContext, dataFormat, "keyOrTrustStoreParametersRef", ((XMLSecurityDataFormat)this.definition).getKeyOrTrustStoreParametersRef());
        }
        if (((XMLSecurityDataFormat)this.definition).getKeyOrTrustStoreParameters() != null) {
            this.setProperty(camelContext, dataFormat, "keyOrTrustStoreParameters", ((XMLSecurityDataFormat)this.definition).getKeyOrTrustStoreParameters());
        }
        if (((XMLSecurityDataFormat)this.definition).getNamespaces() != null) {
            this.setProperty(camelContext, dataFormat, "namespaces", ((XMLSecurityDataFormat)this.definition).getNamespaces());
        }
        if (((XMLSecurityDataFormat)this.definition).getKeyPassword() != null) {
            this.setProperty(camelContext, dataFormat, "keyPassword", ((XMLSecurityDataFormat)this.definition).getKeyPassword());
        }
        if (((XMLSecurityDataFormat)this.definition).getDigestAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "digestAlgorithm", ((XMLSecurityDataFormat)this.definition).getDigestAlgorithm());
        }
        if (((XMLSecurityDataFormat)this.definition).getMgfAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "mgfAlgorithm", ((XMLSecurityDataFormat)this.definition).getMgfAlgorithm());
        }
        boolean isAddKeyValueForEncryptedKey = ((XMLSecurityDataFormat)this.definition).getAddKeyValueForEncryptedKey() == null || ((XMLSecurityDataFormat)this.definition).getAddKeyValueForEncryptedKey() != false;
        this.setProperty(camelContext, dataFormat, "addKeyValueForEncryptedKey", isAddKeyValueForEncryptedKey);
    }
}

