/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.spi.DataFormat;

public class JsonDataFormatReifier
extends DataFormatReifier<JsonDataFormat> {
    public JsonDataFormatReifier(DataFormatDefinition definition) {
        super((JsonDataFormat)definition);
    }

    @Override
    protected DataFormat doCreateDataFormat(CamelContext camelContext) {
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.XStream) {
            this.setProperty(camelContext, this, "dataFormatName", "json-xstream");
        } else if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Jackson) {
            this.setProperty(camelContext, this, "dataFormatName", "json-jackson");
        } else if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Gson) {
            this.setProperty(camelContext, this, "dataFormatName", "json-gson");
        } else if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.Fastjson) {
            this.setProperty(camelContext, this, "dataFormatName", "json-fastjson");
        } else {
            this.setProperty(camelContext, this, "dataFormatName", "json-johnzon");
        }
        if (((JsonDataFormat)this.definition).getUnmarshalType() == null && ((JsonDataFormat)this.definition).getUnmarshalTypeName() != null) {
            try {
                ((JsonDataFormat)this.definition).setUnmarshalType(camelContext.getClassResolver().resolveMandatoryClass(((JsonDataFormat)this.definition).getUnmarshalTypeName()));
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if (((JsonDataFormat)this.definition).getCollectionType() == null && ((JsonDataFormat)this.definition).getCollectionTypeName() != null) {
            try {
                ((JsonDataFormat)this.definition).setCollectionType(camelContext.getClassResolver().resolveMandatoryClass(((JsonDataFormat)this.definition).getCollectionTypeName()));
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return super.doCreateDataFormat(camelContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (((JsonDataFormat)this.definition).getObjectMapper() != null) {
            String ref = ((JsonDataFormat)this.definition).getObjectMapper().startsWith("#") ? ((JsonDataFormat)this.definition).getObjectMapper() : "#" + ((JsonDataFormat)this.definition).getObjectMapper();
            this.setProperty(camelContext, dataFormat, "objectMapper", ref);
        }
        if (((JsonDataFormat)this.definition).getUseDefaultObjectMapper() != null) {
            this.setProperty(camelContext, dataFormat, "useDefaultObjectMapper", ((JsonDataFormat)this.definition).getUseDefaultObjectMapper());
        }
        if (((JsonDataFormat)this.definition).getUnmarshalType() != null) {
            this.setProperty(camelContext, dataFormat, "unmarshalType", ((JsonDataFormat)this.definition).getUnmarshalType());
        }
        if (((JsonDataFormat)this.definition).getPrettyPrint() != null) {
            this.setProperty(camelContext, dataFormat, "prettyPrint", ((JsonDataFormat)this.definition).getPrettyPrint());
        }
        if (((JsonDataFormat)this.definition).getJsonView() != null) {
            this.setProperty(camelContext, dataFormat, "jsonView", ((JsonDataFormat)this.definition).getJsonView());
        }
        if (((JsonDataFormat)this.definition).getInclude() != null) {
            this.setProperty(camelContext, dataFormat, "include", ((JsonDataFormat)this.definition).getInclude());
        }
        if (((JsonDataFormat)this.definition).getAllowJmsType() != null) {
            this.setProperty(camelContext, dataFormat, "allowJmsType", ((JsonDataFormat)this.definition).getAllowJmsType());
        }
        if (((JsonDataFormat)this.definition).getCollectionTypeName() != null) {
            this.setProperty(camelContext, dataFormat, "collectionType", ((JsonDataFormat)this.definition).getCollectionTypeName());
        }
        if (((JsonDataFormat)this.definition).getUseList() != null) {
            this.setProperty(camelContext, dataFormat, "useList", ((JsonDataFormat)this.definition).getUseList());
        }
        if (((JsonDataFormat)this.definition).getEnableJaxbAnnotationModule() != null) {
            this.setProperty(camelContext, dataFormat, "enableJaxbAnnotationModule", ((JsonDataFormat)this.definition).getEnableJaxbAnnotationModule());
        }
        if (((JsonDataFormat)this.definition).getModuleClassNames() != null) {
            this.setProperty(camelContext, dataFormat, "moduleClassNames", ((JsonDataFormat)this.definition).getModuleClassNames());
        }
        if (((JsonDataFormat)this.definition).getModuleRefs() != null) {
            this.setProperty(camelContext, dataFormat, "moduleRefs", ((JsonDataFormat)this.definition).getModuleRefs());
        }
        if (((JsonDataFormat)this.definition).getEnableFeatures() != null) {
            this.setProperty(camelContext, dataFormat, "enableFeatures", ((JsonDataFormat)this.definition).getEnableFeatures());
        }
        if (((JsonDataFormat)this.definition).getDisableFeatures() != null) {
            this.setProperty(camelContext, dataFormat, "disableFeatures", ((JsonDataFormat)this.definition).getDisableFeatures());
        }
        if (((JsonDataFormat)this.definition).getPermissions() != null) {
            this.setProperty(camelContext, dataFormat, "permissions", ((JsonDataFormat)this.definition).getPermissions());
        }
        if (((JsonDataFormat)this.definition).getAllowUnmarshallType() != null) {
            this.setProperty(camelContext, dataFormat, "allowUnmarshallType", ((JsonDataFormat)this.definition).getAllowUnmarshallType());
        }
        if (((JsonDataFormat)this.definition).getPermissions() == null && ((JsonDataFormat)this.definition).getUnmarshalType() != null) {
            String allow = "+" + ((JsonDataFormat)this.definition).getUnmarshalType().getName();
            this.setProperty(camelContext, dataFormat, "permissions", allow);
        }
    }
}

