/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

public class MulticastReifier
extends ProcessorReifier<MulticastDefinition> {
    public MulticastReifier(ProcessorDefinition<?> definition) {
        super((MulticastDefinition)definition);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor answer = this.createChildProcessor(routeContext, true);
        if (!(answer instanceof MulticastProcessor)) {
            ArrayList<Processor> list = new ArrayList<Processor>(1);
            list.add(answer);
            answer = this.createCompositeProcessor(routeContext, list);
        }
        return answer;
    }

    @Override
    protected Processor createCompositeProcessor(RouteContext routeContext, List<Processor> list) throws Exception {
        long timeout;
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        boolean isParallelProcessing = ((MulticastDefinition)this.definition).getParallelProcessing() != null && ((MulticastDefinition)this.definition).getParallelProcessing() != false;
        boolean isShareUnitOfWork = ((MulticastDefinition)this.definition).getShareUnitOfWork() != null && ((MulticastDefinition)this.definition).getShareUnitOfWork() != false;
        boolean isStreaming = ((MulticastDefinition)this.definition).getStreaming() != null && ((MulticastDefinition)this.definition).getStreaming() != false;
        boolean isStopOnException = ((MulticastDefinition)this.definition).getStopOnException() != null && ((MulticastDefinition)this.definition).getStopOnException() != false;
        boolean isParallelAggregate = ((MulticastDefinition)this.definition).getParallelAggregate() != null && ((MulticastDefinition)this.definition).getParallelAggregate() != false;
        boolean isStopOnAggregateException = ((MulticastDefinition)this.definition).getStopOnAggregateException() != null && ((MulticastDefinition)this.definition).getStopOnAggregateException() != false;
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "Multicast", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        long l = timeout = ((MulticastDefinition)this.definition).getTimeout() != null ? ((MulticastDefinition)this.definition).getTimeout() : 0L;
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        if (((MulticastDefinition)this.definition).getOnPrepareRef() != null) {
            ((MulticastDefinition)this.definition).setOnPrepare((Processor)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)((MulticastDefinition)this.definition).getOnPrepareRef(), Processor.class));
        }
        MulticastProcessor answer = new MulticastProcessor(routeContext.getCamelContext(), list, strategy, isParallelProcessing, threadPool, shutdownThreadPool, isStreaming, isStopOnException, timeout, ((MulticastDefinition)this.definition).getOnPrepare(), isShareUnitOfWork, isParallelAggregate, isStopOnAggregateException);
        return answer;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((MulticastDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((MulticastDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(((MulticastDefinition)this.definition).getStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((MulticastDefinition)this.definition).getStrategyMethodName());
                if (((MulticastDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(((MulticastDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                    adapter.setAllowNullOldExchange(((MulticastDefinition)this.definition).getStrategyMethodAllowNull().booleanValue());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((MulticastDefinition)this.definition).getStrategyRef());
            }
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(routeContext.getCamelContext());
        }
        if (((MulticastDefinition)this.definition).getShareUnitOfWork() != null && ((MulticastDefinition)this.definition).getShareUnitOfWork().booleanValue()) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }
}

