/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AsyncProcessor;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DynamicRouter;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.RouteContext;

public class DynamicRouterReifier
extends ExpressionReifier<DynamicRouterDefinition<?>> {
    public DynamicRouterReifier(ProcessorDefinition<?> definition) {
        super((ExpressionNode)DynamicRouterDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression expression = ((DynamicRouterDefinition)this.definition).getExpression().createExpression(routeContext);
        String delimiter = ((DynamicRouterDefinition)this.definition).getUriDelimiter() != null ? ((DynamicRouterDefinition)this.definition).getUriDelimiter() : ",";
        DynamicRouter dynamicRouter = new DynamicRouter(routeContext.getCamelContext(), expression, delimiter);
        if (((DynamicRouterDefinition)this.definition).getIgnoreInvalidEndpoints() != null) {
            dynamicRouter.setIgnoreInvalidEndpoints(((DynamicRouterDefinition)this.definition).getIgnoreInvalidEndpoints().booleanValue());
        }
        if (((DynamicRouterDefinition)this.definition).getCacheSize() != null) {
            dynamicRouter.setCacheSize(((DynamicRouterDefinition)this.definition).getCacheSize().intValue());
        }
        ErrorHandlerFactory builder = routeContext.getErrorHandlerFactory();
        AsyncProcessor errorHandler = (AsyncProcessor)ErrorHandlerReifier.reifier(builder).createErrorHandler(routeContext, (Processor)dynamicRouter.newRoutingSlipProcessorForErrorHandler());
        dynamicRouter.setErrorHandler(errorHandler);
        return dynamicRouter;
    }
}

