/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.config.BatchResequencerConfig;
import org.apache.camel.model.config.ResequencerConfig;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="resequence")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResequenceDefinition
extends ProcessorDefinition<ResequenceDefinition>
implements OutputNode {
    @Metadata(required=false)
    @XmlElements(value={@XmlElement(name="batch-config", type=BatchResequencerConfig.class), @XmlElement(name="stream-config", type=StreamResequencerConfig.class)})
    private ResequencerConfig resequencerConfig;
    @XmlTransient
    private BatchResequencerConfig batchConfig;
    @XmlTransient
    private StreamResequencerConfig streamConfig;
    @XmlElementRef
    @Metadata(required=true)
    private ExpressionDefinition expression;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();

    public ResequenceDefinition() {
    }

    public ResequenceDefinition(Expression expression) {
        if (expression != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    public ResequenceDefinition stream() {
        return this.stream(StreamResequencerConfig.getDefault());
    }

    public ResequenceDefinition batch() {
        return this.batch(BatchResequencerConfig.getDefault());
    }

    public ResequenceDefinition stream(StreamResequencerConfig config) {
        this.streamConfig = config;
        this.batchConfig = null;
        return this;
    }

    public ResequenceDefinition batch(BatchResequencerConfig config) {
        this.batchConfig = config;
        this.streamConfig = null;
        return this;
    }

    public ResequenceDefinition timeout(long timeout) {
        if (this.streamConfig != null) {
            this.streamConfig.setTimeout(timeout);
        } else {
            if (this.batchConfig == null) {
                this.batch();
            }
            this.batchConfig.setBatchTimeout(timeout);
        }
        return this;
    }

    public ResequenceDefinition deliveryAttemptInterval(long deliveryAttemptInterval) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("deliveryAttemptInterval() only supported for stream resequencer");
        }
        this.streamConfig.setDeliveryAttemptInterval(deliveryAttemptInterval);
        return this;
    }

    public ResequenceDefinition rejectOld() {
        if (this.streamConfig == null) {
            throw new IllegalStateException("rejectOld() only supported for stream resequencer");
        }
        this.streamConfig.setRejectOld(true);
        return this;
    }

    public ResequenceDefinition size(int batchSize) {
        if (this.streamConfig != null) {
            throw new IllegalStateException("size() only supported for batch resequencer");
        }
        if (this.batchConfig == null) {
            this.batch();
        }
        this.batchConfig.setBatchSize(batchSize);
        return this;
    }

    public ResequenceDefinition capacity(int capacity) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("capacity() only supported for stream resequencer");
        }
        this.streamConfig.setCapacity(capacity);
        return this;
    }

    public ResequenceDefinition allowDuplicates() {
        if (this.streamConfig != null) {
            throw new IllegalStateException("allowDuplicates() only supported for batch resequencer");
        }
        if (this.batchConfig == null) {
            this.batch();
        }
        this.batchConfig.setAllowDuplicates(true);
        return this;
    }

    public ResequenceDefinition reverse() {
        if (this.streamConfig != null) {
            throw new IllegalStateException("reverse() only supported for batch resequencer");
        }
        if (this.batchConfig == null) {
            this.batch();
        }
        this.batchConfig.setReverse(true);
        return this;
    }

    public ResequenceDefinition ignoreInvalidExchanges() {
        if (this.streamConfig != null) {
            this.streamConfig.setIgnoreInvalidExchanges(true);
        } else {
            if (this.batchConfig == null) {
                this.batch();
            }
            this.batchConfig.setIgnoreInvalidExchanges(true);
        }
        return this;
    }

    public ResequenceDefinition comparator(ExpressionResultComparator comparator) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("comparator() only supported for stream resequencer");
        }
        this.streamConfig.setComparator(comparator);
        return this;
    }

    public String toString() {
        return "Resequencer[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public String getShortName() {
        return "resequence";
    }

    @Override
    public String getLabel() {
        return "resequencer[" + (this.getExpression() != null ? this.getExpression().getLabel() : "") + "]";
    }

    public ResequencerConfig getResequencerConfig() {
        return this.resequencerConfig;
    }

    public void setResequencerConfig(ResequencerConfig resequencerConfig) {
        this.resequencerConfig = resequencerConfig;
    }

    public BatchResequencerConfig getBatchConfig() {
        if (this.batchConfig == null && this.resequencerConfig != null && this.resequencerConfig instanceof BatchResequencerConfig) {
            return (BatchResequencerConfig)this.resequencerConfig;
        }
        return this.batchConfig;
    }

    public StreamResequencerConfig getStreamConfig() {
        if (this.streamConfig == null && this.resequencerConfig != null && this.resequencerConfig instanceof StreamResequencerConfig) {
            return (StreamResequencerConfig)this.resequencerConfig;
        }
        return this.streamConfig;
    }

    public void setBatchConfig(BatchResequencerConfig batchConfig) {
        this.batchConfig = batchConfig;
    }

    public void setStreamConfig(StreamResequencerConfig streamConfig) {
        this.streamConfig = streamConfig;
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    public void setExpression(Expression expression) {
        this.setExpression(new ExpressionDefinition(expression));
    }
}

