/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.component.milo.KeyStoreLoader;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

@UriParams
public class MiloClientConfiguration
implements Cloneable {
    private static final String DEFAULT_APPLICATION_URI = "http://camel.apache.org/EclipseMilo/Client";
    private static final String DEFAULT_APPLICATION_NAME = "Apache Camel adapter for Eclipse Milo";
    private static final String DEFAULT_PRODUCT_URI = "http://camel.apache.org/EclipseMilo";
    @XmlTransient
    private String endpointUri;
    @UriParam
    private String discoveryEndpointUri;
    @UriParam
    private String discoveryEndpointSuffix;
    @UriParam
    private String clientId;
    @UriParam(label="client", defaultValue="Apache Camel adapter for Eclipse Milo")
    private String applicationName = "Apache Camel adapter for Eclipse Milo";
    @UriParam(label="client", defaultValue="http://camel.apache.org/EclipseMilo/Client")
    private String applicationUri = "http://camel.apache.org/EclipseMilo/Client";
    @UriParam(label="client", defaultValue="http://camel.apache.org/EclipseMilo")
    private String productUri = "http://camel.apache.org/EclipseMilo";
    @UriParam(label="client")
    private Long requestTimeout;
    @UriParam(label="client")
    private Long channelLifetime;
    @UriParam(label="client")
    private String sessionName;
    @UriParam(label="client")
    private Long sessionTimeout;
    @UriParam(label="client")
    private Long maxPendingPublishRequests;
    @UriParam(label="client")
    private Long maxResponseMessageSize;
    @UriParam(label="client")
    private String keyStoreUrl;
    @UriParam(label="client")
    private String keyStoreType = "PKCS12";
    @UriParam(label="client")
    private String keyAlias;
    @UriParam(label="client", secret=true)
    private String keyStorePassword;
    @UriParam(label="client", secret=true)
    private String keyPassword;
    @UriParam(label="client", javaType="java.lang.String")
    private Set<String> allowedSecurityPolicies = new HashSet<String>();
    @UriParam(label="client")
    private boolean overrideHost;

    public MiloClientConfiguration() {
    }

    public MiloClientConfiguration(MiloClientConfiguration other) {
        this.endpointUri = other.endpointUri;
        this.discoveryEndpointUri = other.discoveryEndpointUri;
        this.discoveryEndpointSuffix = other.discoveryEndpointSuffix;
        this.clientId = other.clientId;
        this.applicationName = other.applicationName;
        this.applicationUri = other.applicationUri;
        this.productUri = other.productUri;
        this.requestTimeout = other.requestTimeout;
        this.channelLifetime = other.channelLifetime;
        this.sessionName = other.sessionName;
        this.maxPendingPublishRequests = other.maxPendingPublishRequests;
        this.maxResponseMessageSize = other.maxResponseMessageSize;
        this.keyStoreUrl = other.keyStoreUrl;
        this.keyStoreType = other.keyStoreType;
        this.keyAlias = other.keyAlias;
        this.keyStorePassword = other.keyStorePassword;
        this.keyPassword = other.keyPassword;
        this.allowedSecurityPolicies = this.allowedSecurityPolicies != null ? new HashSet<String>(other.allowedSecurityPolicies) : null;
        this.overrideHost = other.overrideHost;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setDiscoveryEndpointUri(String endpointDiscoveryUri) {
        this.discoveryEndpointUri = endpointDiscoveryUri;
    }

    public String getDiscoveryEndpointUri() {
        return this.discoveryEndpointUri;
    }

    public void setDiscoveryEndpointSuffix(String endpointDiscoverySuffix) {
        this.discoveryEndpointSuffix = endpointDiscoverySuffix;
    }

    public String getDiscoveryEndpointSuffix() {
        return this.discoveryEndpointSuffix;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public void setProductUri(String productUri) {
        this.productUri = productUri;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public void setRequestTimeout(Long reconnectTimeout) {
        this.requestTimeout = reconnectTimeout;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setChannelLifetime(Long channelLifetime) {
        this.channelLifetime = channelLifetime;
    }

    public Long getChannelLifetime() {
        return this.channelLifetime;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionTimeout(Long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setMaxPendingPublishRequests(Long maxPendingPublishRequests) {
        this.maxPendingPublishRequests = maxPendingPublishRequests;
    }

    public Long getMaxPendingPublishRequests() {
        return this.maxPendingPublishRequests;
    }

    public void setMaxResponseMessageSize(Long maxResponseMessageSize) {
        this.maxResponseMessageSize = maxResponseMessageSize;
    }

    public Long getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    public void setKeyStoreUrl(String keyStoreUrl) {
        this.keyStoreUrl = keyStoreUrl;
    }

    public String getKeyStoreUrl() {
        return this.keyStoreUrl;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setAllowedSecurityPolicies(Set<String> allowedSecurityPolicies) {
        this.allowedSecurityPolicies = allowedSecurityPolicies;
    }

    public void setAllowedSecurityPolicies(String allowedSecurityPolicies) {
        String[] policies;
        if (allowedSecurityPolicies == null) {
            this.allowedSecurityPolicies = null;
            return;
        }
        this.allowedSecurityPolicies = new HashSet<String>();
        for (String policy : policies = allowedSecurityPolicies.split(",")) {
            String adding = null;
            try {
                adding = SecurityPolicy.fromUri((String)policy).getSecurityPolicyUri();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (adding == null) {
                try {
                    adding = SecurityPolicy.valueOf((String)policy).getSecurityPolicyUri();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (adding == null) {
                throw new RuntimeException("Unknown security policy: " + policy);
            }
            this.allowedSecurityPolicies.add(adding);
        }
    }

    public Set<String> getAllowedSecurityPolicies() {
        return this.allowedSecurityPolicies;
    }

    public void setOverrideHost(boolean overrideHost) {
        this.overrideHost = overrideHost;
    }

    public boolean isOverrideHost() {
        return this.overrideHost;
    }

    public MiloClientConfiguration clone() {
        return new MiloClientConfiguration(this);
    }

    public String toCacheId() {
        if (this.clientId != null && !this.clientId.isEmpty()) {
            return this.endpointUri + "|" + this.clientId;
        }
        return this.endpointUri;
    }

    public OpcUaClientConfigBuilder newBuilder() {
        return MiloClientConfiguration.mapToClientConfiguration(this);
    }

    private static OpcUaClientConfigBuilder mapToClientConfiguration(MiloClientConfiguration configuration) {
        OpcUaClientConfigBuilder builder = new OpcUaClientConfigBuilder();
        MiloClientConfiguration.whenHasText((Supplier<String>)((Supplier)configuration::getApplicationName), value -> builder.setApplicationName(LocalizedText.english((String)value)));
        MiloClientConfiguration.whenHasText((Supplier<String>)((Supplier)configuration::getApplicationUri), arg_0 -> ((OpcUaClientConfigBuilder)builder).setApplicationUri(arg_0));
        MiloClientConfiguration.whenHasText((Supplier<String>)((Supplier)configuration::getProductUri), arg_0 -> ((OpcUaClientConfigBuilder)builder).setProductUri(arg_0));
        if (configuration.getRequestTimeout() != null) {
            builder.setRequestTimeout(Unsigned.uint((long)configuration.getRequestTimeout()));
        }
        if (configuration.getChannelLifetime() != null) {
            builder.setChannelLifetime(Unsigned.uint((long)configuration.getChannelLifetime()));
        }
        MiloClientConfiguration.whenHasText((Supplier<String>)((Supplier)configuration::getSessionName), value -> builder.setSessionName(() -> value));
        if (configuration.getSessionTimeout() != null) {
            builder.setSessionTimeout(UInteger.valueOf((long)configuration.getSessionTimeout()));
        }
        if (configuration.getMaxPendingPublishRequests() != null) {
            builder.setMaxPendingPublishRequests(UInteger.valueOf((long)configuration.getMaxPendingPublishRequests()));
        }
        if (configuration.getMaxResponseMessageSize() != null) {
            builder.setMaxResponseMessageSize(UInteger.valueOf((long)configuration.getMaxPendingPublishRequests()));
        }
        if (configuration.getKeyStoreUrl() != null) {
            MiloClientConfiguration.setKey(configuration, builder);
        }
        return builder;
    }

    private static void setKey(MiloClientConfiguration configuration, OpcUaClientConfigBuilder builder) {
        KeyStoreLoader.Result result;
        KeyStoreLoader loader = new KeyStoreLoader();
        try {
            loader.setType(configuration.getKeyStoreType());
            loader.setUrl(configuration.getKeyStoreUrl());
            loader.setKeyStorePassword(configuration.getKeyStorePassword());
            loader.setKeyAlias(configuration.getKeyAlias());
            loader.setKeyPassword(configuration.getKeyPassword());
            result = loader.load();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Failed to load key", e);
        }
        if (result == null) {
            throw new IllegalStateException("Key not found in keystore");
        }
        builder.setCertificate(result.getCertificate());
        builder.setKeyPair(result.getKeyPair());
    }

    private static void whenHasText(Supplier<String> valueSupplier, Consumer<String> valueConsumer) {
        String value = (String)valueSupplier.get();
        if (value != null && !value.isEmpty()) {
            valueConsumer.accept(value);
        }
    }
}

